% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{averageMatrices}
\alias{averageMatrices}
\title{Average matrices}
\usage{
averageMatrices(mat_list, rFun = "max", cFun = "median", reduceFun = "+")
}
\arguments{
\item{mat_list}{a list of matrices to aggregate (eg spectrograms or
modulation spectra)}

\item{rFun, }{cFun functions used to determine the number of rows and columns
in the result}

\item{reduceFun}{function used to aggregate}
}
\description{
Internal soundgen function.
}
\details{
Takes a list of matrices (normally modulation spectra), interpolates them to
have the same size, and then reduces them (eg takes the average).
}
\examples{
mat_list = list(
  matrix(1:30, nrow = 5),
  matrix(80:17, nrow = 8)
)
soundgen:::averageMatrices(mat_list)
soundgen:::averageMatrices(mat_list, cFun = 'max', reduceFun = '*')
}
\keyword{internal}
