% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/gmwm_logic.cpp, src/gmwm_logic.h
\name{gmwm_engine}
\alias{gmwm_engine}
\title{Engine for obtaining the GMWM Estimator}
\usage{
gmwm_engine(
  theta,
  desc,
  objdesc,
  model_type,
  wv_empir,
  omega,
  scales,
  starting
)
}
\arguments{
\item{theta}{A \code{vec} with dimensions N x 1 that contains user-supplied initial values for parameters}

\item{desc}{A \code{vector<string>} indicating the models that should be considered.}

\item{objdesc}{A \code{field<vec>} containing a list of parameters (e.g. AR(1) = c(1,1), ARMA(p,q) = c(p,q,1))}

\item{model_type}{A \code{string} that represents the model transformation}

\item{wv_empir}{A \code{vec} that contains the empirical wavelet variance}

\item{omega}{A \code{mat} that represents the covariance matrix.}

\item{scales}{A \code{vec} that contains the scales or taus (2^(1:J))}

\item{starting}{A \code{bool} that indicates whether we guessed starting (T) or the user supplied estimates (F).}
}
\value{
A \code{vec} that contains the parameter estimates from GMWM estimator.
}
\description{
This function uses the Generalized Method of Wavelet Moments (GMWM) to estimate the parameters of a time series model.
}
\details{
If type = "imu" or "ssm", then parameter vector should indicate the characters of the models that compose the latent or state-space model.
The model options are:
\itemize{
  \item{"AR1"}{a first order autoregressive process with parameters \eqn{(\phi,\sigma^2)}{phi, sigma^2}}
  \item{"ARMA"}{an autoregressive moving average process with parameters \eqn{(\phi _p, \theta _q, \sigma^2)}{phi[p], theta[q], sigma^2}}
  \item{"DR"}{a drift with parameter \eqn{\omega}{omega}}
  \item{"QN"}{a quantization noise process with parameter \eqn{Q}}
  \item{"RW"}{a random walk process with parameter \eqn{\sigma^2}{sigma^2}}
  \item{"WN"}{a white noise process with parameter \eqn{\sigma^2}{sigma^2}}
}
If model_type = "imu" or type = "ssm" then
starting values pass through an initial bootstrap and pseudo-optimization before being passed to the GMWM optimization.
If robust = TRUE the function takes the robust estimate of the wavelet variance to be used in the GMWM estimation procedure.
}
\references{
Wavelet variance based estimation for composite stochastic processes, S. Guerrier and Robust Inference for Time Series Models: a Wavelet-Based Framework, S. Guerrier
}
\author{
JJB
}
\keyword{internal}
