% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{genSurv}
\alias{genSurv}
\title{Generate survival data}
\usage{
genSurv(
  dtName,
  survDefs,
  digits = 3,
  timeName = NULL,
  censorName = NULL,
  eventName = "event",
  typeName = "type",
  keepEvents = FALSE,
  idName = "id",
  envir = parent.frame()
)
}
\arguments{
\item{dtName}{Name of data set}

\item{survDefs}{Definitions of survival}

\item{digits}{Number of digits for rounding}

\item{timeName}{A string to indicate the name of a combined competing risk
time-to-event outcome that reflects the minimum observed value of all 
time-to-event outcomes. Defaults to NULL, indicating that each time-to-event
outcome will be included in dataset.}

\item{censorName}{The name of a time to event variable that is the censoring
variable. Will be ignored if timeName is NULL.}

\item{eventName}{The name of the new numeric/integer column representing the
competing event outcomes. If censorName is specified, the integer value for
that event will be 0. Defaults to "event", but will be ignored 
if timeName is NULL.}

\item{typeName}{The name of the new character column that will indicate the
event type. The type will be the unique variable names in survDefs. Defaults
to "type", but will be ignored if timeName is NULL.}

\item{keepEvents}{Indicator to retain original "events" columns. Defaults
to FALSE.}

\item{idName}{Name of id field in existing data set.}

\item{envir}{Optional environment, defaults to current calling environment.}
}
\value{
Original data table with survival time
}
\description{
Survival data is added to an existing data set.
}
\examples{
# Baseline data definitions

def <- defData(varname = "x1", formula = .5, dist = "binary")
def <- defData(def, varname = "x2", formula = .5, dist = "binary")
def <- defData(def, varname = "grp", formula = .5, dist = "binary")

# Survival data definitions

sdef <- defSurv(
  varname = "survTime", formula = "1.5*x1",
  scale = "grp*50 + (1-grp)*25", shape = "grp*1 + (1-grp)*1.5"
)

sdef <- defSurv(sdef, varname = "censorTime", scale = 80, shape = 1)

sdef

# Baseline data definitions

dtSurv <- genData(300, def)

# Add survival times

dtSurv <- genSurv(dtSurv, sdef)

head(dtSurv)
}
\concept{generate_data}
