% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_data.R
\name{defRepeatAdd}
\alias{defRepeatAdd}
\title{Add multiple (similar) rows to definitions table that will be used to add data to an
existing data.table}
\usage{
defRepeatAdd(
  dtDefs = NULL,
  nVars,
  prefix,
  formula,
  variance = 0,
  dist = "normal",
  link = "identity",
  id = "id"
)
}
\arguments{
\item{dtDefs}{Definition data.table to be modified}

\item{nVars}{Number of new variables to define}

\item{prefix}{Prefix (character) for new variables}

\item{formula}{An R expression for mean (string)}

\item{variance}{Number or formula}

\item{dist}{Distribution. For possibilities, see details}

\item{link}{The link function for the mean, see details}

\item{id}{A string indicating the field name for the unique record identifier}
}
\value{
A data.table named dtName that is an updated data definitions table
}
\description{
Add multiple (similar) rows to definitions table that will be used to add data to an
existing data.table
}
\details{
The possible data distributions are: `r paste0(.getDists(),collapse = ", ")`.
}
\examples{
def <- defRepeatAdd(
  nVars = 4, prefix = "g", formula = "1/3;1/3;1/3",
  variance = 0, dist = "categorical"
)
def <- defDataAdd(def, varname = "a", formula = "1;1", dist = "trtAssign")
def <- defRepeatAdd(def, 8, "b", formula = "5 + a", variance = 3, dist = "normal")
def <- defDataAdd(def, "y", formula = "0.10", dist = "binary")

def
}
\seealso{
[distributions]
}
\concept{define_data}
