% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalised_models.R
\name{PenalisedOpenMx}
\alias{PenalisedOpenMx}
\alias{PenalisedLinearSystem}
\title{Penalised Structural Equation Model}
\usage{
PenalisedOpenMx(
  xdata,
  adjacency,
  penalised = NULL,
  residual_covariance = NULL,
  Lambda,
  ...
)

PenalisedLinearSystem(xdata, adjacency, penalised = NULL, Lambda = NULL, ...)
}
\arguments{
\item{xdata}{matrix with observations as rows and variables as columns.
Column names must be defined and in line with the row and column names of
\code{adjacency}.}

\item{adjacency}{binary adjacency matrix of the Directed Acyclic Graph
(transpose of the asymmetric matrix A in Reticular Action Model notation).
The row and column names of this matrix must be defined.}

\item{penalised}{optional binary matrix indicating which coefficients are
regularised.}

\item{residual_covariance}{binary and symmetric matrix encoding the nonzero
entries in the residual covariance matrix (symmetric matrix S in Reticular
Action Model notation). By default, this is the identity matrix (no
residual covariance).}

\item{Lambda}{matrix of parameters controlling the level of sparsity. Only
the minimum, maximum and length are used in \code{\link{PenalisedOpenMx}}.}

\item{...}{additional parameters passed to \code{\link[OpenMx]{OpenMx}} functions (for
\code{\link{PenalisedOpenMx}}), or \code{\link[glmnet]{glmnet}} (for
\code{\link{PenalisedLinearSystem}}).}
}
\value{
A list with: \item{selected}{matrix of binary selection status. Rows
  correspond to different regularisation parameters. Columns correspond to
  different parameters to estimated.} \item{beta_full}{matrix of model
  coefficients. Rows correspond to different regularisation parameters.
  Columns correspond to different parameters to estimated.}
}
\description{
Runs penalised Structural Equation Modelling using implementations from
\code{\link[OpenMx]{OpenMx}} functions (for \code{\link{PenalisedOpenMx}}),
or using series of penalised regressions with \code{\link[glmnet]{glmnet}}
(for \code{\link{PenalisedLinearSystem}}). The function
\code{\link{PenalisedLinearSystem}} does not accommodate latent variables.
These functions are not using stability.
}
\examples{
\donttest{
# Data simulation
pk <- c(3, 2, 3)
dag <- LayeredDAG(layers = pk)
theta <- dag
theta[2, 4] <- 0
set.seed(1)
simul <- SimulateStructural(theta = theta, pk = pk, output_matrices = TRUE)

# Running regularised SEM (OpenMx)
if (requireNamespace("OpenMx", quietly = TRUE)) {
  mysem <- PenalisedOpenMx(
    xdata = simul$data, adjacency = dag,
    Lambda = seq(1, 10, 1)
  )
  OpenMxMatrix(vect = mysem$selected[3, ], adjacency = dag)
}

# Running regularised SEM (glmnet)
mysem <- PenalisedLinearSystem(
  xdata = simul$data, adjacency = dag
)
LinearSystemMatrix(vect = mysem$selected[20, ], adjacency = dag)
}
}
\references{
\insertRef{RegSEM}{sharp}
}
\seealso{
\code{\link{SelectionAlgo}}, \code{\link{VariableSelection}},
  \code{\link{OpenMxMatrix}},
  \code{\link{LinearSystemMatrix}}

Other underlying algorithm functions: 
\code{\link{CART}()},
\code{\link{ClusteringAlgo}()},
\code{\link{PenalisedGraphical}()},
\code{\link{PenalisedRegression}()}
}
\concept{underlying algorithm functions}
