% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture_model.R
\name{mixture_model}
\alias{mixture_model}
\title{Fit a mixture model to classify serostatus}
\usage{
mixture_model(
  antibody_level,
  breaks = 40,
  pi = c(0.2, 0.8),
  mu = c(2, 6),
  sigma = c(0.5, 1)
)
}
\arguments{
\item{antibody_level}{- vector of the corresponding raw antibody level}

\item{breaks}{- number of intervals which the antibody_level are grouped into}

\item{pi}{- proportion of susceptible, infected}

\item{mu}{- a vector of means of component distributions (vector of 2 numbers in ascending order)}

\item{sigma}{-  a vector of standard deviations of component distributions (vector of 2 number)}
}
\value{
a list of class mixture_model with the following items
  \item{df}{the dataframe used for fitting the model}
  \item{info}{list of 3 items parameters, distribution and constraints for the fitted model}
  \item{susceptible}{fitted distribution for susceptible}
  \item{infected}{fitted distribution for infected}
}
\description{
Refers to section 11.1 - 11.4
}
\examples{
df <- vzv_be_2001_2003[vzv_be_2001_2003$age < 40.5,]
data <- df$VZVmIUml[order(df$age)]
model <- mixture_model(antibody_level = data)
model$info
plot(model)
}
