% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default_params_doc.R
\name{default_params_doc}
\alias{default_params_doc}
\title{Default parameter documentation}
\usage{
default_params_doc(
  phy,
  traits,
  num_concealed_states,
  idparslist,
  initparsopt,
  idparsfix,
  idparsopt,
  idfactorsopt,
  parsfix,
  cond,
  root_state_weight,
  sampling_fraction,
  tol,
  maxiter,
  optimethod,
  num_cycles,
  loglik_penalty,
  is_complete_tree,
  verbose,
  num_threads,
  atol,
  rtol,
  method,
  parameter,
  setting_calculation,
  num_steps,
  see_ancestral_states,
  lambdas,
  mus,
  qs,
  crown_age,
  pool_init_states,
  maxSpec,
  conditioning,
  non_extinction,
  max_tries,
  drop_extinct,
  seed,
  prob_func,
  parameters,
  masterBlock,
  diff.conceal,
  trait_info,
  lambd_and_modeSpe,
  initloglik,
  initfactors,
  idparsfuncdefpar,
  functions_defining_params,
  state_names,
  transition_matrix,
  model,
  concealed_spec_rates,
  shift_matrix,
  q_matrix,
  lambda_list,
  object,
  params,
  param_posit,
  ml_pars,
  mu_vector,
  max_spec,
  min_spec,
  max_species_extant,
  tree_size_hist,
  start_at_crown,
  optimmethod
)
}
\arguments{
\item{phy}{phylogenetic tree of class \code{phylo}, rooted and with
branch lengths.}

\item{traits}{vector with trait states for each tip in the phylogeny. The
order of the states must be the same as the tree tips. For help, see
\code{vignette("starting_secsse", package = "secsse")}.}

\item{num_concealed_states}{number of concealed states, generally equivalent
to the number of examined states in the dataset.}

\item{idparslist}{overview of parameters and their values.}

\item{initparsopt}{a numeric vector with the initial guess of the parameters
to be estimated.}

\item{idparsfix}{a numeric vector with the ID of the fixed parameters.}

\item{idparsopt}{a numeric vector with the ID of parameters to be estimated.}

\item{idfactorsopt}{id of the factors that will be optimized. There are not
fixed factors, so use a constant within \code{functions_defining_params}.}

\item{parsfix}{a numeric vector with the value of the fixed parameters.}

\item{cond}{condition on the existence of a node root: \code{"maddison_cond"},
\code{"proper_cond"} (default). For details, see vignette.}

\item{root_state_weight}{the method to weigh the states:
\code{"maddison_weights"}, \code{"proper_weights"} (default) or \code{"equal_weights"}.
It can also be specified for the root state: the vector \code{c(1, 0, 0)}
indicates state 1 was the root state.}

\item{sampling_fraction}{vector that states the sampling proportion per
trait state. It must have as many elements as there are trait states.}

\item{tol}{A numeric vector with the maximum tolerance of the optimization
algorithm. Default is \code{c(1e-04, 1e-05, 1e-05)}.}

\item{maxiter}{max number of iterations. Default is
\code{1000 * round((1.25) ^ length(idparsopt))}.}

\item{num_cycles}{Number of cycles of the optimization. When set to \code{Inf},
the optimization will be repeated until the result is, within the
tolerance, equal to the starting values, with a maximum of 10 cycles.}

\item{loglik_penalty}{the size of the penalty for all parameters; default is
0 (no penalty).}

\item{is_complete_tree}{logical specifying whether or not a tree with all its
extinct species is provided. If set to \code{TRUE}, it also assumes that all
\emph{all} extinct lineages are present on the tree. Defaults to \code{FALSE}.}

\item{verbose}{sets verbose output; default is \code{TRUE} when \code{optimmethod} is
\code{"simplex"}. If \code{optimmethod} is set to \code{"simplex"}, then even if set to
\code{FALSE}, optimizer output will be shown.}

\item{num_threads}{number of threads to be used. Default is one thread.}

\item{atol}{A numeric specifying the absolute tolerance of integration.}

\item{rtol}{A numeric specifying the relative tolerance of integration.}

\item{method}{integration method used, available are:
\code{"odeint::runge_kutta_cash_karp54"}, \code{"odeint::runge_kutta_fehlberg78"},
\code{"odeint::runge_kutta_dopri5"}, \code{"odeint::bulirsch_stoer"} and
\code{"odeint::runge_kutta4"}. Default method is: \code{"odeint::bulirsch_stoer"}.}

\item{parameter}{list where first vector represents lambdas, the second
mus and the third transition rates.}

\item{setting_calculation}{argument used internally to speed up calculation.
It should be left blank (default : \code{setting_calculation = NULL}).}

\item{num_steps}{number of substeps to show intermediate likelihoods
along a branch.}

\item{see_ancestral_states}{Boolean for whether the ancestral states should
be shown? Defaults to \code{FALSE}.}

\item{lambdas}{speciation rates, in the form of a list of matrices.}

\item{mus}{extinction rates, in the form of a vector.}

\item{qs}{The Q matrix, for example the result of function q_doubletrans, but
generally in the form of a matrix.}

\item{crown_age}{crown age of the tree, tree will be simulated conditional
on non-extinction and this crown age.}

\item{pool_init_states}{pool of initial states at the crown, in case this is
different from all available states, otherwise leave at NULL}

\item{conditioning}{can be \code{"obs_states"}, \code{"true_states"} or \code{"none"}, the
tree is simulated until one is generated that contains all observed states
(\code{"obs_states"}), all true states (e.g. all combinations of obs and hidden
states), or is always returned (\code{"none"}). Alternatively, a vector with
the names of required observed states can be provided, e.g. c("S", "N").}

\item{non_extinction}{boolean stating if the tree should be conditioned on
non-extinction of the crown lineages. Defaults to \code{TRUE}.}

\item{max_tries}{maximum number of simulations to try to obtain a tree.}

\item{drop_extinct}{boolean stating if extinct species should be dropped from
the tree. Defaults to \code{TRUE}.}

\item{seed}{pseudo-random number generator seed.}

\item{prob_func}{a function to calculate the probability of interest, see
description.}

\item{parameters}{list where first vector represents lambdas, the second mus
and the third transition rates.}

\item{masterBlock}{matrix of transitions among only examined states, \code{NA} in
the main diagonal, used to build the full transition rates matrix.}

\item{diff.conceal}{Boolean stating if the concealed states should be
different. E.g. that the transition rates for the concealed
states are different from the transition rates for the examined states.
Normally it should be \code{FALSE} in order to avoid having a huge number of
parameters.}

\item{trait_info}{data frame where first column has species ids and the second
one is the trait associated information.}

\item{lambd_and_modeSpe}{a matrix with the 4 models of speciation possible.}

\item{initloglik}{A numeric with the value of loglikehood obtained prior to
optimisation. Only used internally.}

\item{initfactors}{the initial guess for a factor (it should be set to \code{NULL}
when no factors).}

\item{idparsfuncdefpar}{id of the parameters which will be a function of
optimized and/or fixed parameters. The order of id should match
\code{functions_defining_params}.}

\item{functions_defining_params}{a list of functions. Each element will be a
function which defines a parameter e.g. \code{id_3 <- (id_1 + id_2) / 2}. See
example.}

\item{state_names}{vector of names of all observed states.}

\item{transition_matrix}{a matrix containing a description of all speciation
events, where the first column indicates the source state, the second and
third column indicate the two daughter states, and the fourth column gives
the rate indicator used. E.g.: \verb{["SA", "S", "A", 1]} for a trait state
\code{"SA"} which upon speciation generates two daughter species with traits
\code{"S"} and \code{"A"}, where the number 1 is used as indicator for optimization
of the likelihood.}

\item{model}{used model, choice of \code{"ETD"} (Examined Traits Diversification),
\code{"CTD"} (Concealed Traits Diversification) or \code{"CR"} (Constant Rate).}

\item{concealed_spec_rates}{vector specifying the rate indicators for each
concealed state, length should be identical to \code{num_concealed_states}. If
left empty when using the CTD model, it is assumed that all available
speciation rates are distributed uniformly over the concealed states.}

\item{shift_matrix}{matrix of shifts, indicating in order:
\enumerate{
\item starting state (typically the column in the transition matrix)
\item ending state (typically the row in the transition matrix)
\item associated rate indicator.
}}

\item{q_matrix}{\code{q_matrix} with only transitions between observed states.}

\item{lambda_list}{previously generated list of lambda matrices,
used to infer the rate number to start with.}

\item{object}{lambda matrices, \code{q_matrix} or mu vector.}

\item{params}{parameters in order, where each value reflects the value
of the parameter at that position, e.g. \code{c(0.3, 0.2, 0.1)} will fill out
the value 0.3 for the parameter with rate identifier 1, 0.2 for the
parameter with rate identifier 2 and 0.1 for the parameter with rate
identifier 3.}

\item{param_posit}{initial parameter structure, consisting of a list with
three entries:
\enumerate{
\item lambda matrices
\item mus
\item Q matrix
}

In each entry, integers numbers (1-n) indicate the parameter to be
optimized.}

\item{ml_pars}{resulting parameter estimates as returned by for instance
\code{\link[=cla_secsse_ml]{cla_secsse_ml()}}, having the same structure as \code{param_post}.}

\item{mu_vector}{previously defined mus - used to choose indicator number.}

\item{max_spec}{Maximum number of species in the tree (please note that the
tree is not conditioned on this number, but that this is a safeguard
against generating extremely large trees).}

\item{min_spec}{Minimum number of species in the tree.}

\item{max_species_extant}{Should the maximum number of species be counted in
the reconstructed tree (if TRUE) or in the complete tree (if FALSE).}

\item{tree_size_hist}{if TRUE, returns a vector of all found tree sizes.}

\item{start_at_crown}{if FALSE, the simulation starts with one species
instead of the two assumed by default by secsse (also in ML), and
the resulting crown age will be lower than the set crown age. This allows
for direct comparison with BiSSE and facilitates implementing speciation
effects at the crown.}

\item{optimmethod}{A string with method used for optimization. Default is
\code{"subplex"}. Alternative is \code{"simplex"} and it shouldn't be used in normal
conditions (only for debugging). Both are called from \code{\link[DDD:optimizer]{DDD::optimizer()}},
simplex is implemented natively in \link{DDD}, while subplex is ultimately
called from \code{\link[subplex:subplex]{subplex::subplex()}}.}
}
\value{
Nothing
}
\description{
This function's purpose is to list all parameter documentation to be
inherited by the relevant functions.
}
\keyword{internal}
