% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-quantile.R,
%   R/class-forecast-sample.R, R/get-pit-histogram.R
\name{get_pit_histogram.forecast_quantile}
\alias{get_pit_histogram.forecast_quantile}
\alias{get_pit_histogram.forecast_sample}
\alias{get_pit_histogram}
\alias{get_pit_histogram.default}
\title{Probability integral transformation histogram}
\usage{
\method{get_pit_histogram}{forecast_quantile}(forecast, num_bins = NULL, breaks = NULL, by, ...)

\method{get_pit_histogram}{forecast_sample}(
  forecast,
  num_bins = 10,
  breaks = NULL,
  by,
  integers = c("nonrandom", "random", "ignore"),
  n_replicates = NULL,
  ...
)

get_pit_histogram(forecast, num_bins, breaks, by, ...)

\method{get_pit_histogram}{default}(forecast, num_bins, breaks, by, ...)
}
\arguments{
\item{forecast}{A forecast object (a validated data.table with predicted and
observed values).}

\item{num_bins}{The number of bins in the PIT histogram. For sample-based
forecasts, the default is 10 bins. For quantile-based forecasts, the
default is one bin for each available quantile.
You can control the number of bins by supplying a number. This is fine for
sample-based pit histograms, but may fail for quantile-based formats. In
this case it is preferred to supply explicit breaks points using the
\code{breaks} argument.}

\item{breaks}{Numeric vector with the break points for the bins in the
PIT histogram. This is preferred when creating a PIT histogram based on
quantile-based data. Default is \code{NULL} and breaks will be determined by
\code{num_bins}. If \code{breaks} is used, \code{num_bins} will be ignored.
0 and 1 will always be added as left and right bounds, respectively.}

\item{by}{Character vector with the columns according to which the
PIT values shall be grouped. If you e.g. have the columns 'model' and
'location' in the input data and want to have a PIT histogram for
every model and location, specify \code{by = c("model", "location")}.}

\item{...}{Currently unused. You \emph{cannot} pass additional arguments to scoring
functions via \code{...}. See the \emph{Customising metrics} section below for
details on how to use \code{\link[purrr:partial]{purrr::partial()}} to pass arguments to individual
metrics.}

\item{integers}{How to handle integer forecasts (count data). This is based
on methods described Czado et al. (2007). If "nonrandom" (default) the
function will use the non-randomised PIT method. If "random", will use the
randomised PIT method. If "ignore", will treat integer forecasts as if they
were continuous.}

\item{n_replicates}{The number of draws for the randomised PIT for discrete
predictions. Will be ignored if forecasts are continuous or \code{integers} is
not set to \code{random}.}
}
\value{
A data.table with density values for each bin in the PIT histogram.
}
\description{
Generate a Probability Integral Transformation (PIT) histogram for
validated forecast objects.

See the examples for how to plot the result of this function.
}
\examples{
library("ggplot2")

result <- get_pit_histogram(example_sample_continuous, by = "model")
ggplot(result,  aes(x = mid, y = density)) +
  geom_col() +
  facet_wrap(. ~ model) +
  labs(x = "Quantile", "Density")

# example with quantile data
result <- get_pit_histogram(example_quantile, by = "model")
ggplot(result,  aes(x = mid, y = density)) +
  geom_col() +
  facet_wrap(. ~ model) +
  labs(x = "Quantile", "Density")
}
\references{
Sebastian Funk, Anton Camacho, Adam J. Kucharski, Rachel Lowe,
Rosalind M. Eggo, W. John Edmunds (2019) Assessing the performance of
real-time epidemic forecasts: A case study of Ebola in the Western Area
region of Sierra Leone, 2014-15, \doi{10.1371/journal.pcbi.1006785}
}
\seealso{
\code{\link[=pit_histogram_sample]{pit_histogram_sample()}}
}
\keyword{scoring}
