% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{theme_lucas}
\alias{theme_lucas}
\title{Sarah's go-to theme for ggplot2}
\usage{
theme_lucas()
}
\value{
list of ggproto objects
}
\description{
Requires the \code{hrbrthemes} package and the \verb{PT Sans} and \verb{PT Sans Narrow}
fonts from Google Fonts.
}
\examples{
library(ggplot2)
library(showtext)

# run once to download the PT Sans fonts
font_add_google(name = "PT Sans", family = "PT Sans")
font_add_google(name = "PT Sans Narrow", family = "PT Sans Narrow")
showtext_auto()

# make a plot with theme_lucas()
ggplot(mtcars) +
  aes(x = mpg, y = wt, color = cyl) +
  geom_point() +
  theme_lucas()
}
\author{
Sarah Lucas \email{salucas@umich.edu}
}
