% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_dplyr.R
\name{sfn_filter}
\alias{sfn_filter}
\title{Filter sfn_data by variable/s value}
\usage{
sfn_filter(sfn_data, ..., solar = FALSE)
}
\arguments{
\item{sfn_data}{\code{sfn_data} or \code{sfn_data_multi} object to subset}

\item{...}{expressions to pass to the \code{\link[dplyr]{filter}} function}

\item{solar}{Logical indicating if solar timestamp must used to subset}
}
\value{
For \code{sfn_data} objects, a filtered \code{sfn_data} or NULL if
  no data meet the criteria. For \code{sfn_data_multi} another
  \code{sfn_data_multi} with the sites filtered, and an empty
  \code{sfn_data_multi} if any sites met the criteria
}
\description{
Port of \code{\link[dplyr]{filter}} for \code{sfn_data} and
\code{sfn_data_multi} objects
}
\details{
`sfn_filter` will remove the rows not matching the logical expression/s
provided. So, it will remove cases and will create TIMESTAMP gaps, so its use
is not recommended except in the case of filtering by TIMESTAMP (i.e. to
set several sites (sfn_data_multi) in the same time frame). For other
scenarios (removing extreme environmental conditions values or strange
sapflow measures patterns) see \code{\link{sfn_mutate}} and
\code{\link{sfn_mutate_at}}
}
\examples{
library(dplyr)
library(lubridate)

# data
data('ARG_TRE', package = 'sapfluxnetr')

# by timestamp
foo_timestamp <- get_timestamp(ARG_TRE)

foo_timestamp_trimmed <- foo_timestamp[1:100]

sfn_filter(
  ARG_TRE,
  TIMESTAMP \%in\% foo_timestamp_trimmed
)

# by wind speed value
ws_threshold <- 25

sfn_filter(
  ARG_TRE,
  ws <= ws_threshold
)

## multi
data('ARG_MAZ', package = 'sapfluxnetr')
multi_sfn <- sfn_data_multi(ARG_TRE, ARG_MAZ)

# by timestamp
sfn_filter(
  multi_sfn,
  between(day(TIMESTAMP), 18, 22)
)

# by wind speed value
sfn_filter(
  multi_sfn,
  ws <= ws_threshold
)

}
