% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swish.R
\name{Swish}
\alias{Swish}
\title{Switch Activation Function}
\usage{
Swish(x)
}
\arguments{
\item{x}{A numeric vector. All elements must be finite and
non-missing.}
}
\value{
A numeric vector where the ReLU function has been applied
to each element of \code{x}.
}
\description{
The switch activation function is defined as:
}
\details{
\deqn{f(x) = x \cdot \text{sigmoid}(x)}
}
\examples{

Swish(c(-1, 0, 1, 2))

# Can also be used in rxode2:
x <- rxode2({
   r<- Swish(time)
})

e <- et(c(-1, 0, 1, 2))

rxSolve(x, e)

}
\seealso{
Other Activation Functions: 
\code{\link{ELU}()},
\code{\link{GELU}()},
\code{\link{PReLU}()},
\code{\link{ReLU}()},
\code{\link{SELU}()},
\code{\link{dELU}()},
\code{\link{dGELU}()},
\code{\link{dPReLU}()},
\code{\link{dReLU}()},
\code{\link{dSELU}()},
\code{\link{dSwish}()},
\code{\link{dlReLU}()},
\code{\link{dsoftplus}()},
\code{\link{lReLU}()},
\code{\link{softplus}()}
}
\author{
Matthew Fidler
}
\concept{Activation Functions}
