% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_else_rvec.R
\name{if_else_rvec}
\alias{if_else_rvec}
\title{Vectorised If-Else, When Condition is an Rvec}
\usage{
if_else_rvec(condition, true, false, missing = NULL, size = NULL)
}
\arguments{
\item{condition}{An object of class \link[=rvec_lgl]{rvec_lgl}.}

\item{true, false}{Vectors (including rvecs) to use for
\code{TRUE} and \code{FALSE} values of \code{condition}.}

\item{missing}{Vectors to use for \code{NA} values of
\code{condition}. Optional.}

\item{size}{Length of output. Optional.}
}
\value{
An rvec with the same number of
\link[=n_draw]{draws} as \code{condition}.
}
\description{
A version of
\href{https://dplyr.tidyverse.org/reference/if_else.html}{if_else}
for the situation where \code{condition} is an rvec.
}
\examples{
x <- rvec(list(c(1, 11),
               c(2, 5),
               c(22, 6)))

x > 10 ## rvec_lgl

## if_else_rvec needed when
## 'condition' is an rvec
if_else_rvec(x > 10, 10, x)

## dplyr::if_else works when
## 'true', 'false', or 'missing'
## (but not 'condition') are rvecs
library(dplyr)
if_else(c(TRUE, FALSE, TRUE), x, 100)
}
\seealso{
\itemize{
\item base R function \code{\link[=ifelse]{ifelse()}} does not not work
correctly if any of the inputs are rvecs.
\item \strong{dplyr} function
\href{https://dplyr.tidyverse.org/reference/if_else.html}{if_else}
works correctly if arguments \code{true}, \code{false} or \code{missing}
are rvecs, but not if argument \code{condition} is an \code{rvec}.
}
}
