% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dcauchy_rvec}
\alias{dcauchy_rvec}
\alias{pcauchy_rvec}
\alias{qcauchy_rvec}
\alias{rcauchy_rvec}
\title{The Cauchy Distribution, Using Multiple Draws}
\usage{
dcauchy_rvec(x, location = 0, scale = 1, log = FALSE)

pcauchy_rvec(q, location = 0, scale = 1, lower.tail = TRUE, log.p = FALSE)

qcauchy_rvec(p, location = 0, scale = 1, lower.tail = TRUE, log.p = FALSE)

rcauchy_rvec(n, location = 0, scale = 1, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{location}{Center of distribution.
Default is \code{0}.
See \code{\link[stats:Cauchy]{stats::dcauchy()}}. Can be an rvec.}

\item{scale}{Scale parameter.
Default is \code{1}.
See \code{\link[stats:Cauchy]{stats::dcauchy()}}. Can be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}
\item Otherwise an ordinary R vector.
}
}
\description{
Density, distribution function,
quantile function and random generation for the
Cauchy distribution, modified to work with
rvecs.
}
\details{
Functions \code{dcauchy_rvec()}, \code{pcauchy_rvec()},
\code{pcauchy_rvec()} and \code{rcauchy_rvec()} work like
base R functions \code{\link[=dcauchy]{dcauchy()}}, \code{\link[=pcauchy]{pcauchy()}},
\code{\link[=qcauchy]{qcauchy()}}, and \code{\link[=rcauchy]{rcauchy()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rcauchy_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dcauchy_rvec()}, \code{pcauchy_rvec()},
\code{pcauchy_rvec()} and \code{rcauchy_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\examples{
x <- rvec(list(c(3, -5.1),
               c(0, -2.3)))
dcauchy_rvec(x)
pcauchy_rvec(x)

rcauchy_rvec(n = 2,
             location = c(-5, 5),
             n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dcauchy]{dcauchy()}}
\item \code{\link[=pcauchy]{pcauchy()}}
\item \code{\link[=qcauchy]{qcauchy()}}
\item \code{\link[=rcauchy]{rcauchy()}}
\item \link[stats:Distributions]{stats::distributions}.
}
}
