% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildModMedSemModel.R
\name{buildModMedSemModel}
\alias{buildModMedSemModel}
\title{Builds model for moderated mediation anaysis using SEM}
\usage{
buildModMedSemModel(
  xvar,
  mvars,
  yvar,
  xmmod = NULL,
  mymod = NULL,
  cmvars = NULL,
  cyvars = NULL
)
}
\arguments{
\item{xvar}{independent variable (predictor)}

\item{mvars}{vector of names of mediators}

\item{yvar}{dependent variable}

\item{xmmod}{moderator of a path(s)}

\item{mymod}{moderator of b path(s)}

\item{cmvars}{covariates for predicting the mediators}

\item{cyvars}{covariates for predicting the dependent variable}
}
\value{
lavaan model to be used in moderatedMediationSem
}
\description{
Builds model for moderated mediation anaysis using SEM
}
\examples{
model <-  buildModMedSemModel(xvar="procJustice", mvars= c("cynicism"),
          yvar = "CPB", xmmod = "insecure",mymod = "gender" ,cmvars =c("age"))
}
