% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bridges.R
\name{target_distribution_from_log_density_formula}
\alias{target_distribution_from_log_density_formula}
\title{Construct target distribution from a formula specifying log density.}
\usage{
target_distribution_from_log_density_formula(log_density_formula)
}
\arguments{
\item{log_density_formula}{Formula for which right-hand side specifies
expression for logarithm of (unnormalized) density of target distribution.}
}
\value{
A list with entries
\itemize{
\item \code{log_density}: A function to evaluate log density function for target
distribution given current position vector.
\item \code{value_and_gradient_log_density}: A function to evaluate value and gradient
of log density function for target distribution given current position
vector, returning as a list with entries \code{value} and \code{gradient}.
}
}
\description{
Construct target distribution from a formula specifying log density.
}
\examples{
target_distribution <- target_distribution_from_log_density_formula(
  ~ (-(x^2 + y^2) / 8 - (x^2 - y)^2 - (x - 1)^2 / 10)
)
target_distribution$value_and_gradient_log_density(c(0.1, -0.3))
}
