% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-utils.R
\name{stay_windows}
\alias{stay_windows}
\alias{stay_windows.src_env}
\alias{stay_windows.character}
\alias{stay_windows.list}
\alias{stay_windows.default}
\title{Stays}
\usage{
stay_windows(x, ...)

\method{stay_windows}{src_env}(
  x,
  id_type = "icustay",
  win_type = id_type,
  in_time = "start",
  out_time = "end",
  interval = hours(1L),
  patient_ids = NULL,
  ...
)

\method{stay_windows}{character}(x, ...)

\method{stay_windows}{list}(x, ..., patient_ids = NULL)

\method{stay_windows}{default}(x, ...)
}
\arguments{
\item{x}{Data source (is coerced to \code{src_env} using \code{as_src_env()})}

\item{...}{Generic consistency}

\item{id_type}{Type of ID all returned times are relative to}

\item{win_type}{Type of ID for which the in/out times is returned}

\item{in_time, out_time}{column names of the returned in/out times}

\item{interval}{The time interval used to discretize time stamps with,
specified as \code{\link[base:difftime]{base::difftime()}} object}

\item{patient_ids}{Patient IDs used to subset the result}
}
\value{
An \code{id_tbl} containing the selected IDs and depending on values
passed as \code{in_time} and \code{out_time}, start and end times of the ID passed as
\code{win_var}.
}
\description{
Building on functionality offered by the (internal) function \code{\link[=id_map]{id_map()}},
stay windows as well as (in case of differing values being passed as
\code{id_type} and \code{win_type}) an ID mapping is computed.
}
\seealso{
change_id
}
