% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_archive.R
\name{cran_archive}
\alias{cran_archive}
\title{Retrieve CRAN archive}
\usage{
cran_archive(packages = NULL)
}
\arguments{
\item{packages}{A vector with packages or \code{NULL} for all packages.}
}
\value{
A data.frame with 6 columns: Package, Date (of publication), Version,
User, size and status (archived or current).
It is sorted by package name and date.
}
\description{
Retrieve the archive and the current database.
}
\details{
Some packages would get an NA in Version, if \code{\link[=package_version]{package_version()}} were to be
used with \code{strict = FALSE}.
Packages might have been on CRAN but could have been removed and won't show up.
Depending on the data requested and packages currently on CRAN, you might get
a warning regarding a package being both archived and current.
}
\examples{
\donttest{
ap <- available.packages()
a_package <- rownames(ap)[startsWith(rownames(ap), "A")][2]
ca <- cran_archive(a_package)
head(ca)
}
}
\seealso{
The raw source of the data is: \code{\link[tools:CRAN_archive_db]{CRAN_archive_db()}},
\code{\link[tools:CRAN_current_db]{CRAN_current_db()}}.
For some dates and comments about archiving packages: \code{\link[=cran_comments]{cran_comments()}}.

Other meta info from CRAN: 
\code{\link{cran_alias}()},
\code{\link{cran_comments}()},
\code{\link{cran_history}()},
\code{\link{cran_links}()}
}
\concept{meta info from CRAN}
