% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade.R
\name{upgrade}
\alias{upgrade}
\title{Upgrade renv}
\usage{
upgrade(project = NULL, version = NULL, reload = NULL, prompt = interactive())
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{version}{The version of renv to be installed.

When \code{NULL} (the default), the latest version of renv will be installed as
available from CRAN (or whatever active package repositories are active)
Alternatively, you can install the latest development version with
\code{"main"}, or a specific commit with a SHA, e.g. \code{"5049cef8a"}.}

\item{reload}{Boolean; reload renv after install? When \code{NULL} (the
default), renv will be re-loaded only if updating renv for the
active project. Since it's not possible to guarantee a clean reload
in the current session, this will attempt to restart your R session.}

\item{prompt}{Boolean; prompt upgrade before proceeding?}
}
\value{
A boolean value, indicating whether the requested version of
renv was successfully installed. Note that this function is normally
called for its side effects.
}
\description{
Upgrade the version of renv associated with a project, including using
a development version from GitHub. Automatically snapshots the updated
renv, updates the activate script, and restarts R.

If you want to update all packages (including renv) to their latest CRAN
versions, use \code{\link[=update]{update()}}.
}
\section{Note}{
\code{upgrade()} is expected to work for renv versions >= 1.0.1.
To upgrade from prior versions of renv, users should

\code{renv::deactivate();}
\code{install.packages("renv");}
\code{renv::activate();}
\code{renv::record("renv")}
}

\examples{
\dontrun{

# upgrade to the latest version of renv
renv::upgrade()

# upgrade to the latest version of renv on GitHub (development version)
renv::upgrade(version = "main")

}
}
