% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotCor}
\alias{plotCor}
\title{Correlation plot}
\usage{
plotCor(cor)
}
\arguments{
\item{cor}{correlation matrix between of test statistics.  Default considers uncorrelated test statistics}
}
\value{
Plot of correlation matrix
}
\description{
Correlation plot
}
\examples{
# Generate effects
library(mvtnorm)
library(clusterGeneration )

n = 4
Sigma = cov2cor(genPositiveDefMat(n)$Sigma)
beta = t(rmvnorm(1, rep(0, n), Sigma))
stders = rep(.1, n)	

# set names
rownames(Sigma) = colnames(Sigma) = LETTERS[1:n]
rownames(beta) = names(stders) = LETTERS[1:n]

# Run random effects meta-analysis,
# account for correlation 
RE2C( beta, stders, Sigma)

# Make plot
plotCor( Sigma )

}
