% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dracor.R
\name{summary.dracor}
\alias{summary.dracor}
\alias{get_dracor}
\title{Retrieve metadata for all plays in selected corpora}
\usage{
\method{summary}{dracor}(object, ...)

get_dracor(corpus = "all", full_metadata = TRUE)
}
\arguments{
\item{object}{An object of class \code{dracor}.}

\item{...}{Other arguments to be passed to \code{\link{summary.default}}.}

\item{corpus}{Character vector with names of the corpora (you can find all
corpora names in \code{name} column within an object returned by
\code{\link{get_dracor_meta}}) or \code{"all"} (default value). if
\code{"all"}, then all available corpora are downloaded.}

\item{full_metadata}{Logical: if \code{TRUE} (default value), then additional
metadata are retrieved.}
}
\value{
\code{dracor} object that inherits data frame (and can be used as
such).
}
\description{
\code{get_dracor()} request data on all plays in selected (or all) corpora.
\code{get_dracor()} returns \code{dracor} object that inherits
data frame (and can be used as such) but specified \code{\link{summary}}
method.
}
\details{
You need to provide a vector with valid names of the corpora, e.g.
\code{"rus"}, \code{"ger"} or \code{"shake"}. Use function
\code{\link{get_dracor_meta}} to extract names for all available corpora.
}
\section{Functions}{
\itemize{
\item \code{summary(dracor)}: Meaningful summary for \code{dracor_meta} object.

}}
\examples{
\donttest{
tat <- get_dracor("tat")
summary(tat)
get_dracor(c("ita", "span", "greek"))
get_dracor()
}
}
\seealso{
\code{\link{get_dracor_meta}}
}
