% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dens_test.R
\name{dens_test}
\alias{dens_test}
\title{Run the McCracy test for manipulation of the forcing variable}
\usage{
dens_test(rdd_object, bin = NULL, bw = NULL, plot = TRUE, ...)
}
\arguments{
\item{rdd_object}{object of class rdd_data}

\item{bin}{Argument of the \code{\link{DCdensity}} function, the binwidth}

\item{bw}{Argument of the \code{\link{DCdensity}} function, the bandwidth}

\item{plot}{Whether to return a plot. Logical, default ot TRUE.}

\item{\ldots}{Further arguments passed to \code{\link[rdd]{DCdensity}}.}
}
\description{
Calls the \code{\link[rdd]{DCdensity}} test from package \code{rdd} on a \code{rdd_object}.
}
\examples{
data(house)
house_rdd <- rdd_data(y=house$y, x=house$x, cutpoint=0)
dens_test(house_rdd)
}
