% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/display_carto_all.R
\name{display_carto_all}
\alias{display_carto_all}
\title{CARTOcolor palettes viewer}
\usage{
display_carto_all(n = NULL, type = "all", colorblind_friendly = NULL)
}
\arguments{
\item{n}{Number of different colors in the palette, minimum depending on the palette (2 or 3), maximum depending on the palette (7 or 11)}

\item{type}{Type of the palette, can be "quantitative", "diverging", "qualitative", "aggregation", or "all"}

\item{colorblind_friendly}{if TRUE, display only colorblind friendly palettes}
}
\description{
Displays a set of the color palettes from CARTOcolor
}
\examples{
display_carto_all()
display_carto_all(type = "quantitative")
display_carto_all(type = c("diverging", "qualitative", "aggregation"))
display_carto_all(3, type = "quantitative")
display_carto_all(7, type = "quantitative")
display_carto_all(7, colorblind_friendly = TRUE)
display_carto_all(7, type = c("diverging", "qualitative", "aggregation"),
  colorblind_friendly = TRUE)

}
