% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{permTest}
\alias{permTest}
\title{Random mark permutation test for SPDs}
\usage{
permTest(
  x,
  marks,
  timeRange,
  backsight = 10,
  changexpr = expression((t1/t0)^(1/d) - 1),
  nsim,
  bins = NA,
  runm = NA,
  datenormalised = FALSE,
  spdnormalised = FALSE,
  raw = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{CalDates} class object containing the calibrated radiocarbon dates.}

\item{marks}{A numerical or character vector containing the marks associated to each radiocarbon date.}

\item{timeRange}{A vector of length 2 indicating the start and end date of the analysis in cal BP.}

\item{backsight}{A single numeric value defining the distance in time between the focal year and the backsight year for computing the rate of change. Default is 10.}

\item{changexpr}{An expression for calculating the rate of change in SPD between the focal year and a backsight year. Available input options are t1 (the SPD for the focal year), t0 (the SPD for the backsight year), d (the distance between t0 and t1), and any other standard constants and mathematical operators. A sensible default is provided.}

\item{nsim}{Number of random permutations}

\item{bins}{A vector indicating which bin each radiocarbon date is assigned to.}

\item{runm}{A number indicating the window size of the moving average to smooth the SPD. If set to \code{NA} no moving average is applied.Default is NA.}

\item{datenormalised}{If set to TRUE the total probability mass of each calibrated date will be made to sum to unity (the default in most radiocarbon calibration software). This argument will only have an effect if the dates in \code{x} were calibrated without normalisation (via normalised=FALSE in the \code{\link{calibrate}} function), in which case setting \code{datenormalised=TRUE} here will rescale each dates probability mass to sum to unity before aggregating the dates, while setting \code{datenormalised=FALSE} will ensure unnormalised dates are used for both observed and simulated SPDs. Default is FALSE.}

\item{spdnormalised}{A logical variable indicating whether the total probability mass of the SPD is normalised to sum to unity.}

\item{raw}{A logical variable indicating whether all permuted SPDs should be returned or not. Default is FALSE.}

\item{verbose}{A logical variable indicating whether extra information on progress should be reported. Default is TRUE.}
}
\value{
An object of class \code{SpdPermTest} with the following elements
\itemize{
\item{\code{observed}} {A list containing data.frames with the summed probability (column \emph{PrDens} for each calendar year (column \emph{calBP} for each mark/group}
\item{\code{envelope}} {A list containing matrices with the lower and upper bound values of the simulation envelope for each mark/group} 
\item{\code{pValueList}} {A list of p-value associated with each mark/group}  
}
}
\description{
Global and local significance test for comparing shapes of multiple SPDs using random permutations.
}
\details{
The function generates a distribution of expected SPDs by randomly shuffling the marks assigned to each \emph{bin} (see \code{\link{spd}} for details on binning). The resulting distribution of probabilities for each \emph{mark} (i.e. group of dates) for each calendar year is z-transformed, and a 95\% simulation envelope is computed. Local significant departures are defined as instances where the observed SPD (which is also z-transformed) is outside such envelope. A global significance is also computed by comparing the total "area" outside the simulation envelope in the observed and simulated data.
}
\examples{
## compare demographic trajectories in Netherlands and Denmark  
\dontrun{ 
data(euroevol)
nld.dnk = subset(euroevol,Country=="Netherlands"|Country=="Denmark")
bins = binPrep(nld.dnk$SiteID,nld.dnk$C14Age,h=200)
dates = calibrate(nld.dnk$C14Age,nld.dnk$C14SD,normalised=FALSE)
res = permTest(dates,marks=as.character(nld.dnk$Country),nsim=1000,
bins=bins,runm=200,timeRange=c(10000,4000))
round(res$pValueList,4) #extract p-values
summary(res)
par(mfrow=c(2,1))
plot(res,focalm="Netherlands",main="Netherlands")
plot(res,focalm="Denmark",main="Denmark")
}
}
\references{
Crema, E.R., Habu, J., Kobayashi, K., Madella, M., (2016). Summed Probability Distribution of 14 C Dates Suggests Regional Divergences in the Population Dynamics of the Jomon Period in Eastern Japan. PLOS ONE 11, e0154809. doi:10.1371/journal.pone.0154809
}
