% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate_sky_points.R
\name{interpolate_sky_points}
\alias{interpolate_sky_points}
\title{Interpolate sky points}
\usage{
interpolate_sky_points(sky_points, r, k = 3, p = 2, rmax = 200, col_id = "rl")
}
\arguments{
\item{sky_points}{An object of class \emph{data.frame}. The data.frame returned by
\code{\link[=extract_rl]{extract_rl()}} or \code{\link[=extract_dn]{extract_dn()}}, or a
\emph{data.frame} with same basic structure and names.}

\item{r}{\linkS4class{SpatRaster}. The image from which \code{sky_points}
was obtained.}

\item{k}{Numeric vector of length one. Number of k-nearest neighbors.}

\item{p}{Numeric vector of length one. Power for inverse-distance weighting.}

\item{rmax}{Numeric vector of length one. Maximum radius where to search for
\emph{knn}.}

\item{col_id}{Numeric vector of length one. ID of the column with the values
to interpolate.}
}
\value{
An object of class \linkS4class{SpatRaster}.
}
\description{
Interpolate values from canopy photographs.
}
\details{
This function use \code{\link[lidR:dtm_idw]{lidR::knnidw()}} as workhorse function, so
arguments \code{k}, \code{p}, and \code{rmax} are passed to it.

This function is based on \insertCite{Lang2010;textual}{rcaiman}. In theory,
the best result would be obtained with data showing a linear relation between
digital numbers and the amount of light reaching the sensor. See
\code{\link[=extract_radiometry]{extract_radiometry()}} and \code{\link[=read_caim_raw]{read_caim_raw()}} for further details. As a
compromise solution, \code{\link[=gbc]{gbc()}} can be used.

Default parameters are the ones used by
\insertCite{Lang2010;textual}{rcaiman}. The argument \code{rmax} should
account for between 15 to 20 degrees, but it is expressed in pixels units.
So, image resolution and lens projections should be taken into account to set
this argument properly.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue
caim <- normalize(caim, 0, 20847, TRUE)
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
m <- !is.na(z)

bin <- ootb_obia(caim, z, a, m, HSV(239, 0.85, 0.5), gamma = NULL)

g <- sky_grid_segmentation(z, a, 10)
sky_points <- extract_sky_points(r, bin, g, dist_to_plant = 3)
plot(bin)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)
sky_points <- extract_dn(r, sky_points)

sky <- interpolate_sky_points(sky_points, r, col_id = 3)
plot(sky)
plot(r/sky)

# A quick demonstration of how to use trend surface fitting to smooth the
# interpolation
persp(terra::aggregate(sky, 10), theta = 45, phi = 30)
sky_s <- fit_trend_surface(sky, z, a, !is.na(z))
persp(terra::aggregate(sky_s$image, 10), theta = 45, phi = 30)
plot(sky_s$image)
plot(r)
plot(r/sky_s$image)
plot(apply_thr(r/sky_s$image, 0.5))
}
}
\references{
\insertAllCited{}
}
\seealso{
Other Sky Reconstruction Functions: 
\code{\link{cie_sky_model_raster}()},
\code{\link{fit_cie_sky_model}()},
\code{\link{fit_coneshaped_model}()},
\code{\link{fit_trend_surface}()},
\code{\link{fix_reconstructed_sky}()},
\code{\link{ootb_sky_reconstruction}()}
}
\concept{Sky Reconstruction Functions}
