% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rarefy.r
\name{rarefy_cols}
\alias{rarefy_cols}
\alias{rescale_cols}
\alias{rescale_rows}
\title{Transform a counts matrix.}
\usage{
rarefy_cols(mtx, depth = 0.1, n = NULL, seed = 0L, cpus = NULL)

rescale_cols(mtx)

rescale_rows(mtx)
}
\arguments{
\item{mtx}{A matrix-like object.}

\item{depth}{How many observations to keep per sample. When
\verb{0 < depth < 1}, it is taken as the minimum percentage of the
dataset's observations to keep. Ignored when \code{n} is specified.
Default: \code{0.1}}

\item{n}{The number of samples to keep. When \verb{0 < n < 1}, it is taken as
the percentage of samples to keep. If negative, that number or
percentage of samples is dropped. If \code{0}, all samples are kept. If
\code{NULL}, \code{depth} is used instead.
Default: \code{NULL}}

\item{seed}{A positive integer to use for seeding the random number
generator. If you need to create different random rarefactions of the
same matrix, set this seed value to a different number each time.}

\item{cpus}{The number of CPUs to use. Set to \code{NULL} to use all available,
or to \code{1} to disable parallel processing. Default: \code{NULL}}
}
\value{
The rarefied or rescaled matrix.
}
\description{
Rarefaction subset counts so that all samples have the same number of
observations. Rescaling rows or cols scales the matrix values so that row
sums or column sums equal 1.
}
\examples{
    library(rbiom)
    
    # rarefy_cols --------------------------------------
    biom <- hmp50$clone()
    sample_sums(biom) \%>\% head(10)

    biom$counts \%<>\% rarefy_cols(depth=1000)
    sample_sums(biom) \%>\% head(10)
    
    
    # rescaling ----------------------------------------
    mtx <- matrix(sample(1:20), nrow=4)
    mtx
    
    rowSums(mtx)
    rowSums(rescale_rows(mtx))
    
    colSums(mtx)
    colSums(rescale_cols(mtx))

}
\seealso{
Other rarefaction: 
\code{\link{rare_corrplot}()},
\code{\link{rare_multiplot}()},
\code{\link{rare_stacked}()},
\code{\link{rarefy}()},
\code{\link{sample_sums}()}

Other transformations: 
\code{\link{modify_metadata}},
\code{\link{rarefy}()},
\code{\link{slice_metadata}},
\code{\link{subset}()},
\code{\link{with}()}
}
\concept{rarefaction}
\concept{transformations}
