% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reactome_content.R
\name{rba_reactome_mapping}
\alias{rba_reactome_mapping}
\title{Map External ID to Reactome Pathways/Reactions}
\usage{
rba_reactome_mapping(id, resource, map_to, species = "Homo sapiens", ...)
}
\arguments{
\item{id}{Molecule's external Identifier}

\item{resource}{What is the resource of your supplied ID? see:
\href{https://reactome.org/content/schema/objects/ReferenceDatabase/}{Reactome External
Identifiers}}

\item{map_to}{Either "pathways" or "reactions".}

\item{species}{Numeric or Character: NCBI Taxonomy identifier (Human
is 9606), species name (e.g. "Homo sapiens") or Reactome DbId (e.g
Homo sapiens is 48887). See
 \code{\link{rba_reactome_species}} or
 \href{https://reactome.org/content/schema/objects/Species/}{Reactome
 Data Schema: Entries: Species}.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
Data frame where each row is a pathway/reaction and columns are
  pertinent information.
}
\description{
By providing an external identifier from a given resource, you can retrieve
  a list of pathways/reactions that include your supplied ID.
}
\section{Corresponding API Resources}{

 "GET https://reactome.org/ContentService/data/mapping/\{resource\}/
 \{identifier\}/pathways"
 \cr "GET https://reactome.org/ContentService/data/mapping/\{resource\}/
 \{identifier\}/reactions"
}

\examples{
\donttest{
rba_reactome_mapping(id = "PTEN", resource =  "UniProt",
    map_to = "reactions", species = 9606)
}

}
\references{
\itemize{
  \item Marc Gillespie, Bijay Jassal, Ralf Stephan, Marija Milacic, Karen
  Rothfels, Andrea Senff-Ribeiro, Johannes Griss, Cristoffer Sevilla, Lisa
  Matthews, Chuqiao Gong, Chuan Deng, Thawfeek Varusai, Eliot Ragueneau,
  Yusra Haider, Bruce May, Veronica Shamovsky, Joel Weiser, Timothy Brunson,
  Nasim Sanati, Liam Beckman, Xiang Shao, Antonio Fabregat, Konstantinos
  Sidiropoulos, Julieth Murillo, Guilherme Viteri, Justin Cook, Solomon
  Shorser, Gary Bader, Emek Demir, Chris Sander, Robin Haw, Guanming Wu,
  Lincoln Stein, Henning Hermjakob, Peter D’Eustachio, The reactome
  pathway knowledgebase 2022, Nucleic Acids Research, 2021;, kab1028,
  https://doi.org/10.1093/nar/gkab1028
  \item Griss J, Viteri G, Sidiropoulos K, Nguyen V, Fabregat A,
  Hermjakob H. ReactomeGSA - Efficient Multi-Omics Comparative Pathway
  Analysis. Mol Cell Proteomics. 2020 Sep 9. doi: 10.1074/mcp. PubMed
  PMID: 32907876.
  \item \href{https://reactome.org/ContentService/}{Reactome Content
  Services API Documentation}
  \item \href{https://reactome.org/cite/}{Citations note on Reactome website}
  }
}
\concept{"Reactome Content Service - Mapping Related Queries"}
