% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pending_ticks.R
\name{PendingTicks}
\alias{PendingTicks}
\alias{get_pending_ticks_data}
\alias{get_pending_ticks_value}
\alias{put_pending_ticks_data}
\alias{put_pending_ticks_value}
\title{Load and store PendingTicks NBT data}
\usage{
get_pending_ticks_data(x, z, dimension, db = default_db())

get_pending_ticks_value(x, z, dimension, db = default_db())

put_pending_ticks_data(values, x, z, dimension, db = default_db())

put_pending_ticks_value(value, x, z, dimension, db = default_db())
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{values}{A (named) list of list of NBT objects.}

\item{value}{A list of NBT objects.}
}
\value{
\code{get_pending_ticks_value()} returns a list of NBT objects.
\code{get_pending_ticks_data()} returns a named list of lists of NBT objects.
}
\description{
PendingTicks data (tag 51) holds a list of NBT values for
pending ticks.
}
\details{
\itemize{
\item \code{get_pending_ticks_value()} and \code{get_pending_ticks_data()} load
PendingTicks data from \code{db}. \code{get_pending_ticks_value()} loads data for a
single chunk, and \code{get_pending_ticks_data()} loads data for multiple chunks.
\item \code{put_pending_ticks_value()} and \code{put_pending_ticks_data()} store
PendingTicks data for one or multiple chunks into \code{db}.
}
}
