% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rat-cap-words.R
\name{rat_cap_words}
\alias{rat_cap_words}
\title{Capitalization of words}
\usage{
rat_cap_words(x, all = FALSE)
}
\arguments{
\item{x}{A character string}

\item{all}{Logical. If \code{TRUE}, the first letter of every word is capitalized.
If \code{FALSE} (the default), only the first word is capitalized.}
}
\value{
A character string with the specified capitalization.
}
\description{
Capitalize the first letters of words in a string. Can either use sentence
case (i.e., only the first word capitalized; \code{all = FALSE}) or title case
(i.e., all words capitalized; \code{all = TRUE}).
}
\examples{
name <- c("zip code", "state", "final count")
vapply(name, rat_cap_words, character(1))
vapply(name, rat_cap_words, character(1), all = TRUE)
}
