// Generated by rstantools.  Do not edit by hand.

/*
    rater is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rater is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rater.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_hierarchical_dawid_skene_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'hierarchical_dawid_skene', line 12, column 2 to column 16)",
                                                      " (in 'hierarchical_dawid_skene', line 13, column 2 to column 33)",
                                                      " (in 'hierarchical_dawid_skene', line 14, column 2 to column 18)",
                                                      " (in 'hierarchical_dawid_skene', line 15, column 2 to column 30)",
                                                      " (in 'hierarchical_dawid_skene', line 18, column 2 to column 28)",
                                                      " (in 'hierarchical_dawid_skene', line 19, column 2 to column 29)",
                                                      " (in 'hierarchical_dawid_skene', line 20, column 2 to column 19)",
                                                      " (in 'hierarchical_dawid_skene', line 23, column 4 to column 40)",
                                                      " (in 'hierarchical_dawid_skene', line 26, column 6 to column 53)",
                                                      " (in 'hierarchical_dawid_skene', line 24, column 18 to line 27, column 5)",
                                                      " (in 'hierarchical_dawid_skene', line 24, column 4 to line 27, column 5)",
                                                      " (in 'hierarchical_dawid_skene', line 21, column 16 to line 28, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 21, column 2 to line 28, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 30, column 2 to column 19)",
                                                      " (in 'hierarchical_dawid_skene', line 32, column 4 to column 24)",
                                                      " (in 'hierarchical_dawid_skene', line 31, column 17 to line 33, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 31, column 2 to line 33, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 36, column 6 to column 67)",
                                                      " (in 'hierarchical_dawid_skene', line 35, column 19 to line 37, column 5)",
                                                      " (in 'hierarchical_dawid_skene', line 35, column 4 to line 37, column 5)",
                                                      " (in 'hierarchical_dawid_skene', line 34, column 17 to line 38, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 34, column 2 to line 38, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 61, column 2 to column 20)",
                                                      " (in 'hierarchical_dawid_skene', line 63, column 4 to column 41)",
                                                      " (in 'hierarchical_dawid_skene', line 62, column 17 to line 64, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 62, column 2 to line 64, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 41, column 2 to column 24)",
                                                      " (in 'hierarchical_dawid_skene', line 47, column 8 to column 32)",
                                                      " (in 'hierarchical_dawid_skene', line 46, column 13 to line 48, column 7)",
                                                      " (in 'hierarchical_dawid_skene', line 45, column 8 to column 32)",
                                                      " (in 'hierarchical_dawid_skene', line 44, column 18 to line 46, column 7)",
                                                      " (in 'hierarchical_dawid_skene', line 44, column 6 to line 48, column 7)",
                                                      " (in 'hierarchical_dawid_skene', line 43, column 19 to line 49, column 5)",
                                                      " (in 'hierarchical_dawid_skene', line 43, column 4 to line 49, column 5)",
                                                      " (in 'hierarchical_dawid_skene', line 42, column 17 to line 50, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 42, column 2 to line 50, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 51, column 2 to column 34)",
                                                      " (in 'hierarchical_dawid_skene', line 54, column 4 to column 42)",
                                                      " (in 'hierarchical_dawid_skene', line 52, column 16 to line 55, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 52, column 2 to line 55, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 57, column 4 to column 38)",
                                                      " (in 'hierarchical_dawid_skene', line 56, column 17 to line 58, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 56, column 2 to line 58, column 3)",
                                                      " (in 'hierarchical_dawid_skene', line 2, column 2 to column 17)",
                                                      " (in 'hierarchical_dawid_skene', line 3, column 2 to column 17)",
                                                      " (in 'hierarchical_dawid_skene', line 4, column 2 to column 17)",
                                                      " (in 'hierarchical_dawid_skene', line 5, column 2 to column 17)",
                                                      " (in 'hierarchical_dawid_skene', line 6, column 8 to column 9)",
                                                      " (in 'hierarchical_dawid_skene', line 6, column 2 to column 36)",
                                                      " (in 'hierarchical_dawid_skene', line 7, column 8 to column 9)",
                                                      " (in 'hierarchical_dawid_skene', line 7, column 2 to column 36)",
                                                      " (in 'hierarchical_dawid_skene', line 8, column 8 to column 9)",
                                                      " (in 'hierarchical_dawid_skene', line 8, column 2 to column 35)",
                                                      " (in 'hierarchical_dawid_skene', line 9, column 18 to column 19)",
                                                      " (in 'hierarchical_dawid_skene', line 9, column 2 to column 27)",
                                                      " (in 'hierarchical_dawid_skene', line 12, column 10 to column 11)",
                                                      " (in 'hierarchical_dawid_skene', line 13, column 8 to column 9)",
                                                      " (in 'hierarchical_dawid_skene', line 13, column 18 to column 19)",
                                                      " (in 'hierarchical_dawid_skene', line 13, column 21 to column 22)",
                                                      " (in 'hierarchical_dawid_skene', line 14, column 9 to column 10)",
                                                      " (in 'hierarchical_dawid_skene', line 14, column 12 to column 13)",
                                                      " (in 'hierarchical_dawid_skene', line 15, column 18 to column 19)",
                                                      " (in 'hierarchical_dawid_skene', line 15, column 21 to column 22)",
                                                      " (in 'hierarchical_dawid_skene', line 18, column 8 to column 9)",
                                                      " (in 'hierarchical_dawid_skene', line 18, column 18 to column 19)",
                                                      " (in 'hierarchical_dawid_skene', line 18, column 20 to column 21)",
                                                      " (in 'hierarchical_dawid_skene', line 19, column 8 to column 9)",
                                                      " (in 'hierarchical_dawid_skene', line 19, column 18 to column 19)",
                                                      " (in 'hierarchical_dawid_skene', line 20, column 9 to column 10)",
                                                      " (in 'hierarchical_dawid_skene', line 61, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_hierarchical_dawid_skene final : public model_base_crtp<model_hierarchical_dawid_skene> {
private:
  int N;
  int J;
  int K;
  int I;
  std::vector<int> ii;
  std::vector<int> jj;
  std::vector<int> y;
  Eigen::Matrix<double, -1, 1> alpha;
 
public:
  ~model_hierarchical_dawid_skene() { }
  
  inline std::string model_name() const final { return "model_hierarchical_dawid_skene"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_hierarchical_dawid_skene(stan::io::var_context& context__,
                                 unsigned int random_seed__ = 0,
                                 std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_hierarchical_dawid_skene_namespace::model_hierarchical_dawid_skene";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 44;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 44;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 44;
      current_statement__ = 44;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 45;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 45;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 45;
      current_statement__ = 45;
      check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 46;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 46;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 46;
      current_statement__ = 46;
      check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 47;
      context__.validate_dims("data initialization","I","int",
          context__.to_vec());
      I = std::numeric_limits<int>::min();
      
      current_statement__ = 47;
      I = context__.vals_i("I")[(1 - 1)];
      current_statement__ = 47;
      current_statement__ = 47;
      check_greater_or_equal(function__, "I", I, 1);
      current_statement__ = 48;
      validate_non_negative_index("ii", "N", N);
      current_statement__ = 49;
      context__.validate_dims("data initialization","ii","int",
          context__.to_vec(N));
      ii = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 49;
      assign(ii, nil_index_list(), context__.vals_i("ii"),
        "assigning variable ii");
      current_statement__ = 49;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 49;
        current_statement__ = 49;
        check_greater_or_equal(function__, "ii[sym1__]", ii[(sym1__ - 1)], 1);
      }
      current_statement__ = 49;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 49;
        current_statement__ = 49;
        check_less_or_equal(function__, "ii[sym1__]", ii[(sym1__ - 1)], I);}
      current_statement__ = 50;
      validate_non_negative_index("jj", "N", N);
      current_statement__ = 51;
      context__.validate_dims("data initialization","jj","int",
          context__.to_vec(N));
      jj = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 51;
      assign(jj, nil_index_list(), context__.vals_i("jj"),
        "assigning variable jj");
      current_statement__ = 51;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 51;
        current_statement__ = 51;
        check_greater_or_equal(function__, "jj[sym1__]", jj[(sym1__ - 1)], 1);
      }
      current_statement__ = 51;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 51;
        current_statement__ = 51;
        check_less_or_equal(function__, "jj[sym1__]", jj[(sym1__ - 1)], J);}
      current_statement__ = 52;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 53;
      context__.validate_dims("data initialization","y","int",
          context__.to_vec(N));
      y = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 53;
      assign(y, nil_index_list(), context__.vals_i("y"),
        "assigning variable y");
      current_statement__ = 53;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 53;
        current_statement__ = 53;
        check_greater_or_equal(function__, "y[sym1__]", y[(sym1__ - 1)], 0);}
      current_statement__ = 53;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 53;
        current_statement__ = 53;
        check_less_or_equal(function__, "y[sym1__]", y[(sym1__ - 1)], K);}
      current_statement__ = 54;
      validate_non_negative_index("alpha", "K", K);
      current_statement__ = 55;
      context__.validate_dims("data initialization","alpha","double",
          context__.to_vec(K));
      alpha = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 55;
        assign(alpha_flat__, nil_index_list(), context__.vals_r("alpha"),
          "assigning variable alpha_flat__");
        current_statement__ = 55;
        pos__ = 1;
        current_statement__ = 55;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 55;
          assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
            alpha_flat__[(pos__ - 1)], "assigning variable alpha");
          current_statement__ = 55;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 55;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 55;
        current_statement__ = 55;
        check_greater_or_equal(function__, "alpha[sym1__]",
                               alpha[(sym1__ - 1)], 0);}
      current_statement__ = 56;
      validate_positive_index("pi", "K", K);
      current_statement__ = 57;
      validate_non_negative_index("beta_raw", "J", J);
      current_statement__ = 58;
      validate_non_negative_index("beta_raw", "K", K);
      current_statement__ = 59;
      validate_non_negative_index("beta_raw", "K", K);
      current_statement__ = 60;
      validate_non_negative_index("mu", "K", K);
      current_statement__ = 61;
      validate_non_negative_index("mu", "K", K);
      current_statement__ = 62;
      validate_non_negative_index("sigma", "K", K);
      current_statement__ = 63;
      validate_non_negative_index("sigma", "K", K);
      current_statement__ = 64;
      validate_non_negative_index("beta", "J", J);
      current_statement__ = 65;
      validate_non_negative_index("beta", "K", K);
      current_statement__ = 66;
      validate_non_negative_index("beta", "K", K);
      current_statement__ = 67;
      validate_non_negative_index("log_p_z", "I", I);
      current_statement__ = 68;
      validate_non_negative_index("log_p_z", "K", K);
      current_statement__ = 69;
      validate_non_negative_index("log_pi", "K", K);
      current_statement__ = 70;
      validate_non_negative_index("log_lik", "I", I);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += (K - 1);
      num_params_r__ += J * K * K;
      num_params_r__ += K * K;
      num_params_r__ += K * K;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_hierarchical_dawid_skene_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> pi;
      pi = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(pi, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> pi_in__;
      pi_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((K - 1));
      stan::math::fill(pi_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      pi_in__ = in__.vector((K - 1));
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        assign(pi, nil_index_list(),
          stan::math::simplex_constrain(pi_in__, lp__),
          "assigning variable pi");
      } else {
        current_statement__ = 1;
        assign(pi, nil_index_list(), stan::math::simplex_constrain(pi_in__),
          "assigning variable pi");
      }
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> beta_raw;
      beta_raw = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(J, Eigen::Matrix<local_scalar_t__, -1, -1>(K, K));
      stan::math::fill(beta_raw, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 2;
        assign(beta_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(K, K), "assigning variable beta_raw");}
      Eigen::Matrix<local_scalar_t__, -1, -1> mu;
      mu = Eigen::Matrix<local_scalar_t__, -1, -1>(K, K);
      stan::math::fill(mu, DUMMY_VAR__);
      
      current_statement__ = 3;
      mu = in__.matrix(K, K);
      Eigen::Matrix<local_scalar_t__, -1, -1> sigma;
      sigma = Eigen::Matrix<local_scalar_t__, -1, -1>(K, K);
      stan::math::fill(sigma, DUMMY_VAR__);
      
      current_statement__ = 4;
      sigma = in__.matrix(K, K);
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 4;
          if (jacobian__) {
            current_statement__ = 4;
            assign(sigma,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(
                rvalue(sigma,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "sigma"),
                0, lp__), "assigning variable sigma");
          } else {
            current_statement__ = 4;
            assign(sigma,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(
                rvalue(sigma,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "sigma"),
                0), "assigning variable sigma");
          }}}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> beta;
      beta = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(J, Eigen::Matrix<local_scalar_t__, -1, -1>(K, K));
      stan::math::fill(beta, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> log_p_z;
      log_p_z = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(I, Eigen::Matrix<local_scalar_t__, -1, 1>(K));
      stan::math::fill(log_p_z, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> log_pi;
      log_pi = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(log_pi, DUMMY_VAR__);
      
      current_statement__ = 13;
      for (int j = 1; j <= J; ++j) {
        current_statement__ = 8;
        assign(beta, cons_list(index_uni(j), nil_index_list()),
          add(mu, elt_multiply(sigma, beta_raw[(j - 1)])),
          "assigning variable beta");
        current_statement__ = 11;
        for (int k = 1; k <= K; ++k) {
          current_statement__ = 9;
          assign(beta,
            cons_list(index_uni(j),
              cons_list(index_uni(k), nil_index_list())),
            subtract(
              stan::model::deep_copy(
                rvalue(beta,
                  cons_list(index_uni(j),
                    cons_list(index_uni(k), nil_index_list())), "beta")),
              log_sum_exp(
                rvalue(beta,
                  cons_list(index_uni(j),
                    cons_list(index_uni(k), nil_index_list())), "beta"))),
            "assigning variable beta");}}
      current_statement__ = 14;
      assign(log_pi, nil_index_list(), stan::math::log(pi),
        "assigning variable log_pi");
      current_statement__ = 17;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 15;
        assign(log_p_z, cons_list(index_uni(i), nil_index_list()), log_pi,
          "assigning variable log_p_z");}
      current_statement__ = 22;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 20;
        for (int k = 1; k <= K; ++k) {
          current_statement__ = 18;
          assign(log_p_z,
            cons_list(index_uni(ii[(n - 1)]),
              cons_list(index_uni(k), nil_index_list())),
            (log_p_z[(ii[(n - 1)] - 1)][(k - 1)] +
              rvalue(beta,
                cons_list(index_uni(jj[(n - 1)]),
                  cons_list(index_uni(k),
                    cons_list(index_uni(y[(n - 1)]), nil_index_list()))),
                "beta")), "assigning variable log_p_z");}}
      {
        current_statement__ = 27;
        lp_accum__.add(dirichlet_lpdf<propto__>(pi, alpha));
        current_statement__ = 36;
        for (int k = 1; k <= K; ++k) {
          current_statement__ = 34;
          for (int i = 1; i <= K; ++i) {
            current_statement__ = 32;
            if (logical_eq(k, i)) {
              current_statement__ = 30;
              lp_accum__.add(
                normal_lpdf<propto__>(
                  rvalue(mu,
                    cons_list(index_uni(k),
                      cons_list(index_uni(i), nil_index_list())), "mu"), 2,
                  1));
            } else {
              current_statement__ = 28;
              lp_accum__.add(
                normal_lpdf<propto__>(
                  rvalue(mu,
                    cons_list(index_uni(k),
                      cons_list(index_uni(i), nil_index_list())), "mu"), 0,
                  1));
            }}}
        current_statement__ = 37;
        lp_accum__.add(normal_lpdf<propto__>(to_vector(sigma), 0, 1));
        current_statement__ = 40;
        for (int j = 1; j <= J; ++j) {
          current_statement__ = 38;
          lp_accum__.add(
            normal_lpdf<propto__>(to_vector(beta_raw[(j - 1)]), 0, 1));}
        current_statement__ = 43;
        for (int i = 1; i <= I; ++i) {
          current_statement__ = 41;
          lp_accum__.add(log_sum_exp(log_p_z[(i - 1)]));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_hierarchical_dawid_skene_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> pi;
      pi = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(pi, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> pi_in__;
      pi_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((K - 1));
      stan::math::fill(pi_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      pi_in__ = in__.vector((K - 1));
      current_statement__ = 1;
      assign(pi, nil_index_list(), stan::math::simplex_constrain(pi_in__),
        "assigning variable pi");
      std::vector<Eigen::Matrix<double, -1, -1>> beta_raw;
      beta_raw = std::vector<Eigen::Matrix<double, -1, -1>>(J, Eigen::Matrix<double, -1, -1>(K, K));
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 2;
        assign(beta_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(K, K), "assigning variable beta_raw");}
      Eigen::Matrix<double, -1, -1> mu;
      mu = Eigen::Matrix<double, -1, -1>(K, K);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      mu = in__.matrix(K, K);
      Eigen::Matrix<double, -1, -1> sigma;
      sigma = Eigen::Matrix<double, -1, -1>(K, K);
      stan::math::fill(sigma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      sigma = in__.matrix(K, K);
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 4;
          assign(sigma,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_constrain(
              rvalue(sigma,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "sigma"),
              0), "assigning variable sigma");}}
      std::vector<Eigen::Matrix<double, -1, -1>> beta;
      beta = std::vector<Eigen::Matrix<double, -1, -1>>(J, Eigen::Matrix<double, -1, -1>(K, K));
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> log_p_z;
      log_p_z = std::vector<Eigen::Matrix<double, -1, 1>>(I, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(log_p_z, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> log_pi;
      log_pi = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(log_pi, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(pi[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
            vars__.emplace_back(
              rvalue(beta_raw,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "beta_raw"));}}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          vars__.emplace_back(
            rvalue(mu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "mu"));}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          vars__.emplace_back(
            rvalue(sigma,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "sigma"));}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 13;
      for (int j = 1; j <= J; ++j) {
        current_statement__ = 8;
        assign(beta, cons_list(index_uni(j), nil_index_list()),
          add(mu, elt_multiply(sigma, beta_raw[(j - 1)])),
          "assigning variable beta");
        current_statement__ = 11;
        for (int k = 1; k <= K; ++k) {
          current_statement__ = 9;
          assign(beta,
            cons_list(index_uni(j),
              cons_list(index_uni(k), nil_index_list())),
            subtract(
              stan::model::deep_copy(
                rvalue(beta,
                  cons_list(index_uni(j),
                    cons_list(index_uni(k), nil_index_list())), "beta")),
              log_sum_exp(
                rvalue(beta,
                  cons_list(index_uni(j),
                    cons_list(index_uni(k), nil_index_list())), "beta"))),
            "assigning variable beta");}}
      current_statement__ = 14;
      assign(log_pi, nil_index_list(), stan::math::log(pi),
        "assigning variable log_pi");
      current_statement__ = 17;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 15;
        assign(log_p_z, cons_list(index_uni(i), nil_index_list()), log_pi,
          "assigning variable log_p_z");}
      current_statement__ = 22;
      for (int n = 1; n <= N; ++n) {
        current_statement__ = 20;
        for (int k = 1; k <= K; ++k) {
          current_statement__ = 18;
          assign(log_p_z,
            cons_list(index_uni(ii[(n - 1)]),
              cons_list(index_uni(k), nil_index_list())),
            (log_p_z[(ii[(n - 1)] - 1)][(k - 1)] +
              rvalue(beta,
                cons_list(index_uni(jj[(n - 1)]),
                  cons_list(index_uni(k),
                    cons_list(index_uni(y[(n - 1)]), nil_index_list()))),
                "beta")), "assigning variable log_p_z");}}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
              vars__.emplace_back(
                rvalue(beta,
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__),
                      cons_list(index_uni(sym1__), nil_index_list()))),
                  "beta"));}}}
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            vars__.emplace_back(log_p_z[(sym2__ - 1)][(sym1__ - 1)]);}}
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          vars__.emplace_back(log_pi[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(I);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 26;
      for (int i = 1; i <= I; ++i) {
        current_statement__ = 24;
        assign(log_lik, cons_list(index_uni(i), nil_index_list()),
          log_sum_exp(log_p_z[(i - 1)]), "assigning variable log_lik");}
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> pi;
      pi = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(pi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> pi_flat__;
        current_statement__ = 1;
        assign(pi_flat__, nil_index_list(), context__.vals_r("pi"),
          "assigning variable pi_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          assign(pi, cons_list(index_uni(sym1__), nil_index_list()),
            pi_flat__[(pos__ - 1)], "assigning variable pi");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> pi_free__;
      pi_free__ = Eigen::Matrix<double, -1, 1>((K - 1));
      stan::math::fill(pi_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(pi_free__, nil_index_list(), stan::math::simplex_free(pi),
        "assigning variable pi_free__");
      std::vector<Eigen::Matrix<double, -1, -1>> beta_raw;
      beta_raw = std::vector<Eigen::Matrix<double, -1, -1>>(J, Eigen::Matrix<double, -1, -1>(K, K));
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_raw_flat__;
        current_statement__ = 2;
        assign(beta_raw_flat__, nil_index_list(),
          context__.vals_r("beta_raw"), "assigning variable beta_raw_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 2;
            for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
              current_statement__ = 2;
              assign(beta_raw,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                beta_raw_flat__[(pos__ - 1)], "assigning variable beta_raw");
              current_statement__ = 2;
              pos__ = (pos__ + 1);}}}
      }
      Eigen::Matrix<double, -1, -1> mu;
      mu = Eigen::Matrix<double, -1, -1>(K, K);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 3;
        assign(mu_flat__, nil_index_list(), context__.vals_r("mu"),
          "assigning variable mu_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 3;
            assign(mu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              mu_flat__[(pos__ - 1)], "assigning variable mu");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> sigma;
      sigma = Eigen::Matrix<double, -1, -1>(K, K);
      stan::math::fill(sigma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_flat__;
        current_statement__ = 4;
        assign(sigma_flat__, nil_index_list(), context__.vals_r("sigma"),
          "assigning variable sigma_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 4;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 4;
            assign(sigma,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              sigma_flat__[(pos__ - 1)], "assigning variable sigma");
            current_statement__ = 4;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> sigma_free__;
      sigma_free__ = Eigen::Matrix<double, -1, -1>(K, K);
      stan::math::fill(sigma_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          current_statement__ = 4;
          assign(sigma_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_free(
              rvalue(sigma,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "sigma"),
              0), "assigning variable sigma_free__");}}
      for (int sym1__ = 1; sym1__ <= (K - 1); ++sym1__) {
        vars__.emplace_back(pi_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= K; ++sym3__) {
            vars__.emplace_back(
              rvalue(beta_raw,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__), nil_index_list()))),
                "beta_raw"));}}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          vars__.emplace_back(
            rvalue(mu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "mu"));}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          vars__.emplace_back(
            rvalue(sigma_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "sigma_free__"));}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("pi");
    names__.emplace_back("beta_raw");
    names__.emplace_back("mu");
    names__.emplace_back("sigma");
    names__.emplace_back("beta");
    names__.emplace_back("log_p_z");
    names__.emplace_back("log_pi");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J),
                                             static_cast<size_t>(K),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J),
                                             static_cast<size_t>(K),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(I),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(I)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "pi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_p_z" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_pi" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= (K - 1); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "pi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= J; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= I; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_p_z" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_pi" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= I; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"pi\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << K << ",\"cols\":" << K << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" << K << ",\"cols\":" << K << "},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"matrix\",\"rows\":" << K << ",\"cols\":" << K << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << K << ",\"cols\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"log_p_z\",\"type\":{\"name\":\"array\",\"length\":" << I << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"log_pi\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << I << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"pi\",\"type\":{\"name\":\"vector\",\"length\":" << (K - 1) << "},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << K << ",\"cols\":" << K << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" << K << ",\"cols\":" << K << "},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"matrix\",\"rows\":" << K << ",\"cols\":" << K << "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << K << ",\"cols\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"log_p_z\",\"type\":{\"name\":\"array\",\"length\":" << I << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"log_pi\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << I << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_hierarchical_dawid_skene_namespace::model_hierarchical_dawid_skene;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_hierarchical_dawid_skene_namespace::profiles__;
}
#endif
#endif
