% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{gen_summary}
\alias{gen_summary}
\title{Generate evaluation metrics}
\usage{
gen_summary(test_data, prediction_df, df_bin, col_start = "x")
}
\arguments{
\item{test_data}{The data set containing high-dimensional data along with an unique identifier.}

\item{prediction_df}{The data set with 2D embeddings, IDs, and predicted hexagonal IDs.}

\item{df_bin}{The data set with averaged/weighted high-dimensional data.}

\item{col_start}{The text that begin the column name of the high-dimensional data.}
}
\value{
A list contains MSE and AIC values.
}
\description{
This function generates an evaluation data frame based on the provided data and predictions.
}
\examples{
model <- fit_highd_model(training_data = s_curve_noise_training, x = "UMAP1", y = "UMAP2",
nldr_df_with_id = s_curve_noise_umap_scaled, col_start_2d = "UMAP", col_start_highd = "x")
df_bin_centroids <- model$df_bin_centroids
df_bin <- model$df_bin
pred_emb_list <- predict_emb(test_data = s_curve_noise_training,
df_bin_centroids = df_bin_centroids, df_bin = df_bin, type_NLDR = "UMAP")
pred_df_test <- as.data.frame(do.call(cbind, pred_emb_list))
gen_summary(test_data = s_curve_noise_training, prediction_df = pred_df_test,
df_bin = df_bin, col_start = "x")

}
