% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{calc_bins}
\alias{calc_bins}
\title{Calculate the effective number of bins along x-axis and y-axis}
\usage{
calc_bins(data, x, y, hex_size = NA, buffer_x = NA, buffer_y = NA)
}
\arguments{
\item{data}{A tibble or data frame.}

\item{x}{The name of the column that contains values along the x-axis.}

\item{y}{The name of the column that contains values along the y-axis.}

\item{hex_size}{A numeric value that initializes the radius of the outer
circle surrounded by the hexagon.}

\item{buffer_x}{The buffer size along the x-axis.}

\item{buffer_y}{The buffer size along the y-axis.}
}
\value{
A list of numeric values that represents the effective number of
bins along the x and y axes of a hexagonal grid.
}
\description{
This function calculates the effective number of bins along the x and y axes
of a hexagonal grid.
}
\examples{
calc_bins(data = s_curve_noise_umap_scaled, x = "UMAP1", y = "UMAP2",
hex_size = NA, buffer_x = NA, buffer_y = NA)

}
