% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-colours.R
\name{.makeColorMatrix}
\alias{.makeColorMatrix}
\alias{makeColourMatrix}
\title{Convert Raster to colour matrix usable by raster function for plotting}
\usage{
.makeColorMatrix(
  grobToPlot,
  zoomExtent,
  maxpixels,
  legendRange,
  cols = NULL,
  prevMinMax,
  na.color = "#FFFFFF00",
  zero.color = NULL,
  skipSample = TRUE
)
}
\arguments{
\item{grobToPlot}{A \code{SpatialObject}.}

\item{zoomExtent}{An \code{Extent} object for zooming to.
Defaults to whole extent of \code{grobToPlot}.}

\item{maxpixels}{Numeric. Number of cells to subsample the complete
\code{grobToPlot}.}

\item{legendRange}{Numeric vector giving values that, representing the lower
and upper bounds of a legend (i.e., \code{1:10} or
\code{c(1,10)} will give same result) that will override
the data bounds contained within the \code{grobToPlot}.}

\item{cols}{Colours specified in a way that can be understood directly
or by \code{\link[=colorRampPalette]{colorRampPalette()}}.}

\item{na.color}{Character string indicating the colour for \code{NA} values.
Default transparent.}

\item{zero.color}{Character string indicating the colour for zero values,
when zero is the minimum value.
Otherwise, it is treated as any other colour.
Default transparent.
Use \code{NULL} if zero should be the value given to it
by the \code{colortable} associated with the raster.}

\item{skipSample}{Logical. If no downsampling is necessary, skip.
Default \code{TRUE}.}
}
\description{
Internal function.
}
\author{
Eliot McIntire
}
\keyword{internal}
