% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{corp}
\alias{corp}
\title{Bivariate Correlations with Significant Symbols}
\usage{
corp(
  data,
  vrb.nm,
  use = "pairwise.complete.obs",
  method = "pearson",
  digits = 3L,
  p.10 = "",
  p.05 = "*",
  p.01 = "**",
  p.001 = "***",
  lead.zero = FALSE,
  trail.zero = TRUE,
  plus = FALSE,
  diags = FALSE,
  lower = TRUE,
  upper = FALSE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variable columns.}

\item{use}{character vector of length 1 specifying how to handle missing data
when computing the correlations. The options are 1)
"pairwise.complete.obs", 2) "complete.obs", 3) "na.or.complete", 4)
"all.obs", or 5) "everything". See details of \code{\link[stats]{cor}}.}

\item{method}{character vector of length 1 specifying the type of
correlations to be computed. The options are 1) "pearson", 2) "kendall", or
3) "spearman". See details of \code{\link[stats]{cor}}.}

\item{digits}{integer vector of length 1 specifying the number of decimals to
round to.}

\item{p.10}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .10 level.}

\item{p.05}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .05 level.}

\item{p.01}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .01 level.}

\item{p.001}{character vector of length 1 specifying which symbol to append
to the end of any correlation significant at the p < .001 level.}

\item{lead.zero}{logical vector of length 1 specifying whether to retain a
zero in front of the decimal place.}

\item{trail.zero}{logical vector of length 1 specifying whether to retain
zeros after the decimal place (due to rounding).}

\item{plus}{logical vector of length 1 specifying whether to include a plus
sign in front of positive correlations (minus signs are always in front of
negative correlations).}

\item{diags}{logical vector of length 1 specifying whether to retain the
values in the diagonal of the correlation matrix. If TRUE, then the
diagonal will be 1s with \code{digits} number of zeros after the decimal
place (and no significant symbols). If FALSE, then the diagonal will be NA.}

\item{lower}{logical vector of length 1 specifying whether to retain the
lower triangle of the correlation matrix. If TRUE, then the lower triangle
correlations and their significance symbols are retained. If FAlSE, then
the lower triangle will all be NA.}

\item{upper}{logical vector of length 1 specifying whether to retain the
upper triangle of the correlation matrix. If TRUE, then the upper triangle
correlations and their significance symbols are retained. If FAlSE, then
the upper triangle will all be NA.}
}
\value{
data.frame with rownames and colnames equal to \code{vrb.nm}
  containing the bivariate correlations with significance symbols after the
  correlation value, specified by the arguments \code{p.10}, \code{p.05},
  \code{p.01}, and \code{p.001} arguments. The specific elements of the
  return object are determined by the other arguments.
}
\description{
\code{corp} computes bivariate correlations and their associated p-values.
The function is primarily for preparing a correlation table for publication:
the correlations are appended by significant symbols (e.g., asterixis),
\code{corp} is simply \code{\link[psych]{corr.test}} + \code{add_sig_cor}.
}
\examples{

corp(data = mtcars, vrb.nm = c("mpg","cyl","disp","hp","drat")) # no quotes b/c a data.frame
corp(data = attitude, vrb.nm = colnames(attitude))
corp(data = attitude, vrb.nm = colnames(attitude), p.10 = "'") # advance & privileges
corp(data = airquality, vrb.nm = colnames(airquality), plus = TRUE)

}
\seealso{
\code{\link{add_sig_cor}} for adding significant symbols to a correlation matrix,
   \code{\link{add_sig}} for adding significant symbols to any (atomic) vector, matrix, or (3D+) array,
   \code{\link[stats]{cor}} for computing only the correlation coefficients themselves
   \code{\link[psych]{corr.test}} for a function providing confidence intervals as well
}
