% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describes_functions.R
\name{add_sig_cor}
\alias{add_sig_cor}
\title{Add Significance Symbols to a Correlation Matrix}
\usage{
add_sig_cor(
  r,
  p,
  digits = 3,
  p.10 = "",
  p.05 = "*",
  p.01 = "**",
  p.001 = "***",
  lead.zero = FALSE,
  trail.zero = TRUE,
  plus = FALSE,
  diags = FALSE,
  lower = TRUE,
  upper = FALSE
)
}
\arguments{
\item{r}{double numeric matrix of correlation coefficients for which
statistical significance is available. Since its a correlation matrix, it
must be symmetrical and is expected to be a full matrix with all elements
included (not just lower or upper diagonals values included).}

\item{p}{double matrix of p-values for the correlations in \code{r} that are
matched by row and column index. For example, the p-value in the first row
and second column of \code{p} is associated with the correlation in the
first row and second column of \code{r}. If \code{r} and \code{p} do not
have the same dimensions, an error is returned.}

\item{digits}{integer vector of length 1 specifying the number of decimals to
round to.}

\item{p.10}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .10 level.}

\item{p.05}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .05 level.}

\item{p.01}{character vector of length 1 specifying which symbol to append to
the end of any correlation significant at the p < .01 level.}

\item{p.001}{character vector of length 1 specifying which symbol to append
to the end of any correlation significant at the p < .001 level.}

\item{lead.zero}{logical vector of length 1 specifying whether to retain a
zero in front of the decimal place.}

\item{trail.zero}{logical vector of length 1 specifying whether to retain
zeros after the decimal place (due to rounding).}

\item{plus}{logical vector of length 1 specifying whether to include a plus
sign in front of positive correlations (minus signs are always in front of
negative correlations).}

\item{diags}{logical vector of length 1 specifying whether to retain the
values in the diagonal of the correlation matrix. If TRUE, then the
diagonal will be 1s with \code{digits} number of zeros after the decimal
place (and no significant symbols). If FALSE, then the diagonal will be NA.}

\item{lower}{logical vector of length 1 specifying whether to retain the
lower triangle of the correlation matrix. If TRUE, then the lower triangle
correlations and their significance symbols are retained. If FAlSE, then
the lower triangle will all be NA.}

\item{upper}{logical vector of length 1 specifying whether to retain the
upper triangle of the correlation matrix. If TRUE, then the upper triangle
correlations and their significance symbols are retained. If FAlSE, then
the upper triangle will all be NA.}
}
\value{
data.frame with the same dimensions as \code{r} containing the
  correlations and their significance symbols. Elements may or may not contain NA
  values depending on the arguments \code{diags}, \code{lower}, and
  \code{upper}.
}
\description{
\code{add_sig_cor} adds symbols for various p-values cutoffs of statistical
significance. The function inputs a correlation matrix and a numeric matrix
of p-values that correspond to the correlations (i.e., each row and column
match) and then returns a data.frame of correlations with appended
significance symbols. One of the primary applications of this function is use
within \code{\link{corp}} \code{\link{corp_by}}, and \code{\link{corp_ml}}
for correlation matrices.
}
\details{
There are several functions out there that do similar things. Here is one
posted to R-bloggers that uses the \code{corr} function from the \code{Hmisc}
package:
\url{https://www.r-bloggers.com/2020/07/create-a-publication-ready-correlation-matrix-with-significance-levels-in-r/}.
}
\examples{

corr_test <- psych::corr.test(mtcars[1:5])
r <- corr_test[["r"]]
p <- corr_test[["p"]]
add_sig_cor(r = r, p = p)
add_sig_cor(r = r, p = p, digits = 2)
add_sig_cor(r = r, p = p, diags = TRUE)
add_sig_cor(r = r, p = p, lower = FALSE, upper = TRUE)
add_sig_cor(r = r, p = p, lead.zero = TRUE, trail.zero = FALSE)
add_sig_cor(r = r, p = p, plus = TRUE)

}
