% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.0.R
\name{qacf}
\alias{qacf}
\title{Quantile Autocovariance Function (QACF)}
\usage{
qacf(y, tau, y.qdft = NULL, n.cores = 1, cl = NULL)
}
\arguments{
\item{y}{vector or matrix of time series (if matrix, \code{nrow(y)} = length of time series)}

\item{tau}{sequence of quantile levels in (0,1)}

\item{y.qdft}{matrix or array of pre-calculated QDFT (default = \code{NULL}: compute from \code{y} and \code{tau});
if \code{y.qdft} is supplied, \code{y} and \code{tau} can be left unspecified}

\item{n.cores}{number of cores for parallel computing of QDFT if \code{y.qdft = NULL} (default = 1)}

\item{cl}{pre-existing cluster for repeated parallel computing of QDFT (default = \code{NULL})}
}
\value{
matrix or array of quantile autocovariance function
}
\description{
This function computes quantile autocovariance function (QACF) from time series 
or quantile discrete Fourier transform (QDFT).
}
\examples{
y <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
tau <- seq(0.1,0.9,0.05)
# compute from time series
y.qacf <- qacf(y,tau)
# compute from QDFT 
y.qdft <- qdft(y,tau) 
y.qacf <- qacf(y.qdft=y.qdft)
}
