% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teeMod.R
\name{bread.teeMod}
\alias{bread.teeMod}
\title{Extract bread matrix from a \code{teeMod} model fit}
\usage{
\method{bread}{teeMod}(x, ...)
}
\arguments{
\item{x}{a fitted \code{teeMod} model}

\item{...}{arguments passed to methods}
}
\value{
A variance-covariance matrix with row and column entries for the estimated
coefficients in \code{x}, the marginal mean outcome in the control condition,
the marginal mean \code{offset} in the control condition (if an \code{offset}
is provided), and if a moderator variable is specified in the formula for \code{x},
the mean interaction in the control condition of the outcome and \code{offset}
with the moderator variable
}
\description{
An S3method for \code{sandwich::bread} that extracts the bread of the
direct adjustment model sandwich covariance matrix.
}
\details{
This function is a thin wrapper around
\code{.get_tilde_a22_inverse()}.
}
