% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmm_mmle.R
\name{hmm}
\alias{hmm}
\title{MMLE of HMM}
\usage{
hmm(action_seqs, K, paras, verbose = TRUE, ...)
}
\arguments{
\item{action_seqs}{a list of \code{n} action sequences}

\item{K}{number of hidden states}

\item{paras}{a list of elements named \code{para_P1}, \code{para_P}, and \code{para_Q},
providing initial values of model parameters}

\item{verbose}{logical. If \code{TRUE}, progress messages are printed.}

\item{...}{additional arguments passed to \code{\link{optim}}}
}
\value{
a list containing the following elements
\tabular{ll}{
\code{seqs} \tab action sequences coded in integers \cr
\tab \cr
\code{K} \tab number of hidden states \cr
\tab \cr
\code{N} \tab number of distinct actions \cr
\tab \cr
\code{paras_init} \tab a list containing initial values of parameters \cr
\tab \cr
\code{paras_est} \tab a list containing parameter estimates \cr
\tab \cr
\code{init_mllh} \tab initial value of the marginalized likelihood function \cr
\tab \cr
\code{opt_mllh} \tab maximized marginalized likelihood function \cr
\tab \cr
\code{opt_res} \tab object returned by \code{\link{optim}} \cr
}
}
\description{
Maximum marginalized likelihood estimation of HMM.
Optimization is performed through \code{\link{optim}}.
}
\examples{
# generate data
paras_true <- sim_hmm_paras(5, 2)
sim_data <- sim_hmm(20, paras_true, 4, 10)
# randomly generate initial values of parameters
paras_init <- sim_hmm_paras(5, 2, return_prob=FALSE)
# fit hmm
hmm_res <- hmm(sim_data$seqs, 2, paras_init)

}
