% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_train_test.R
\name{split_train_test}
\alias{split_train_test}
\title{Splits the preprocessed \code{\link{data.frame}}.}
\usage{
split_train_test(processed_df, split = 0.7)
}
\arguments{
\item{processed_df}{A preprocessed object of type \code{\link{ppred_examples_df}} returned by \code{prepare_examples()}.}

\item{split}{\code{\link{numeric}} (default 0.7): A train-test split ratio.}
}
\value{
A \code{\link{list}} containing the train- and the test set objects.
}
\description{
Returns train- and test dataframes as a list.
}
\examples{
library(processpredictR)
library(eventdataR)

df <- prepare_examples(patients, "next_activity")
split_train_test(df, split = 0.8)

}
