% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/token_aes.R
\name{token_aes}
\alias{token_aes}
\title{Tokens aesthetics mapping}
\usage{
token_aes(
  size = token_scale(),
  color = token_scale(),
  image = token_scale(),
  opacity = token_scale(),
  shape = "circle",
  attributes = list()
)
}
\arguments{
\item{size}{The scale used for the token size.}

\item{color}{The scale used for the token color,}

\item{image}{The scale used for the token image.}

\item{opacity}{The scale used for the token opacity.}

\item{shape}{The (fixed) SVG shape to be used to draw tokens. Can be either 'circle' (default), 'rect' or 'image'.
In the latter case the image URL needs to be specified as parameter 'token_image'.}

\item{attributes}{A list of additional (fixed) SVG attributes to be added to each token.}
}
\value{
An aesthetics mapping for `animate_process`.
}
\description{
Tokens aesthetics mapping
}
\examples{
data(example_log)

# Change default token sizes / shape
animate_process(example_log, mapping = token_aes(size = token_scale(12), shape = "rect"))
\donttest{
# Change default token color
animate_process(example_log, mapping = token_aes(color = token_scale("red")))

# Change default token opacity
animate_process(example_log, mapping = token_aes(opacity = token_scale("0.2")))

# Change default token image (GIFs work too)
animate_process(example_log,
   mapping = token_aes(shape = "image",
    size = token_scale(10),
    image = token_scale("https://upload.wikimedia.org/wikipedia/en/5/5f/Pacman.gif")))

# A more elaborate example with a secondary data frame
library(eventdataR)
data(traffic_fines)
# Change token color based on a numeric attribute, here the nonsensical 'time' of an event
animate_process(edeaR::filter_trace_frequency(bupaR::sample_n(traffic_fines,1000),percentage=0.95),
  legend = "color", mode = "relative",
  mapping = token_aes(color = token_scale("amount",
                                          scale = "linear",
                                          range = c("yellow","red"))))
}

}
\seealso{
\code{\link{animate_process}}, \code{\link{token_scale}}
}
