% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_annot.R
\name{make_annot}
\alias{make_annot}
\title{Annotate praatpicture plot component}
\usage{
make_annot(plot_component, args)
}
\arguments{
\item{plot_component}{String giving the name of the plot component to
annotate.}

\item{args}{A list of vectors giving arguments used for annotating.
See \link{praatpicture} documentation.}
}
\value{
No return values, called internally by \link{praatpicture} and sibling
functions.
}
\description{
Helper function for annotating plot components made with
praatpicture. Do not use directly, instead use \link{praatpicture} with the
\code{annotate} argument.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile, annotate=c('spectrogram', 0.25, 1500,
'An annotation'))
}
