% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoid.R
\name{add_geoid}
\alias{add_geoid}
\title{Add Standard GEOID to PPMF Data}
\usage{
add_geoid(
  ppmf,
  state = TABBLKST,
  county = TABBLKCOU,
  tract = TABTRACT,
  block_group = TABBLKGRP,
  block = TABBLK,
  level = "block"
)
}
\arguments{
\item{ppmf}{tibble of ppmf data}

\item{state}{Column in ppmf with state (fips) ID. Default is \code{TABBLKST}.}

\item{county}{Column in ppmf with county (fips) ID. Default is \code{TABBLKCOU}.}

\item{tract}{Column in ppmf with tract ID. Default is \code{TABBLKTRACT}.}

\item{block_group}{Column in ppmf with block group ID. Default is \code{TABBLKGRP}}

\item{block}{Column in ppmf with block ID. Default is \code{TABBLK}.}

\item{level}{Geographic level to write the GEOID for. Options are block (default),
block_group, tract, and county.}
}
\value{
input data ppmf with added column GEOID
}
\description{
Adds the GEOID identifier common to spatial census data sets, such as those loaded
by tigris. This allows for easier merging or aggregation by a single variable.
}
\examples{
data(ppmf_ex)
ppmf_ex <- ppmf_ex \%>\% add_geoid()

}
\concept{geoid}
