% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LinearPOSet.R
\name{LinearPOSet}
\alias{LinearPOSet}
\title{Constructing a Linearly Ordered Set.}
\usage{
LinearPOSet(elements)
}
\arguments{
\item{elements}{A character string vector containing the labels of the elements of \eqn{V} in ascending
order according to \eqn{\leq_{lin}}, i.e. such that \code{elements[h]}\eqn{ \leq_{lin} }\code{elements[k]}if and only if \code{h} \eqn{ \leq } \code{k}}
}
\value{
An object of S4 class \code{LinearPOSet} (subclass of \code{POSet})
}
\description{
Constructs a linearly (or completely, or totally) ordered set (V,\eqn{\leq_{lin})}, starting from set \eqn{V},
}
\examples{
elems <- c("a", "b", "c", "d")
linpos <- LinearPOSet(elements = elems)

}
