% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifetab.R
\name{q0_to_m0}
\alias{q0_to_m0}
\title{Convert q0 to m0}
\usage{
q0_to_m0(
  q0,
  sex = NULL,
  a0 = NULL,
  infant = c("constant", "linear", "CD", "AK")
)
}
\arguments{
\item{q0}{Probability of dying in first
year of life. A numeric vector or an \link[rvec:rvec]{rvec}.}

\item{sex}{Biological sex. A vector the same length
as \code{q0}, with labels that can be
interpreted by \code{\link[=reformat_sex]{reformat_sex()}}. Needed only when
\code{infant} is \code{"CD"} or \code{"AK"}.}

\item{a0}{Average age at death for infants who die.
Optional. See help for \code{\link[=lifetab]{lifetab()}}.}

\item{infant}{Calculation method.
See help for \code{\link[=lifetab]{lifetab()}}.
Default is \code{"constant"}.}
}
\value{
A numeric vector or \link[rvec:rvec]{rvec}.
}
\description{
Convert the probability of dying during infancy
(q0) to the mortality rate for infancy (m0).
}
\section{Warning}{


The term "infant mortality rate" is ambiguous.
Demographers sometimes use it to refer to m0
(which is an actual rate) and sometimes use
it to refer to q0 (which is a probability.)
}

\examples{
library(dplyr, warn.conflicts = FALSE)
west_lifetab |>
 filter(age == 0, level <= 5) |>
 select(level, sex, age, mx, qx) |>
 mutate(m0 = q0_to_m0(q0 = qx, sex = sex, infant = "CD"))
}
\seealso{
\itemize{
\item \code{\link[=lifetab]{lifetab()}} Calculate a full life table.
}
}
