% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{marker_binning}
\alias{marker_binning}
\title{Perform binning of markers.}
\usage{
marker_binning(
  dosage_matrix,
  linkage_df,
  r_thresh = NA,
  lod_thresh = NA,
  target_parent = "P1",
  other_parent = "P2",
  max_marker_nr = NULL,
  max_iter = 10,
  log = NULL
)
}
\arguments{
\item{dosage_matrix}{A dosage \code{matrix}.}

\item{linkage_df}{A linkage \code{data.frame}.}

\item{r_thresh}{Numeric. Threshold at which markers are binned. Is calculated if NA.}

\item{lod_thresh}{Numeric. Threshold at which markers are binned. Is calculated if NA.}

\item{target_parent}{A character string specifying the name of the target parent.}

\item{other_parent}{A character string specifying the name of the other parent.}

\item{max_marker_nr}{The maximum number of markers per homologue. If specified, LOD threshold is optimized based on this number.}

\item{max_iter}{Maximum number of iterations to find optimum LOD threshold. Only used if \code{max_marker_nr} is specified.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
A list with the following components:
\item{binned_df}{
  A linkage data.frame with binned markers removed.
}
\item{removed}{
  A data.frame containing binned markers and their representatives.
}
\item{left}{
  Integer. Number markers left.
}
}
\description{
\code{marker_binning} allows for binning of very closely linked markers and choses one representative.
}
\examples{
data("screened_data3", "all_linkages_list_P1_split")
binned_markers<-marker_binning(screened_data3, all_linkages_list_P1_split[["LG2"]][["homologue3"]])
}
