% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/owl.R
\name{control_owl}
\alias{control_owl}
\title{Control arguments for Outcome Weighted Learning}
\usage{
control_owl(
  policy_vars = NULL,
  reuse_scales = TRUE,
  res.lasso = TRUE,
  loss = "hinge",
  kernel = "linear",
  augment = FALSE,
  c = 2^(-2:2),
  sigma = c(0.03, 0.05, 0.07),
  s = 2^(-2:2),
  m = 4
)
}
\arguments{
\item{policy_vars}{Character vector/string or list of character
vectors/strings. Variable names used to restrict the policy.
The names must be a subset of the history names, see get_history_names().
Not passed to \code{owl()}.}

\item{reuse_scales}{The history matrix passed to \code{owl()} is scaled
using \code{\link[=scale]{scale()}} as advised. If \code{TRUE}, the scales of the history matrix
will be saved and reused when applied to (new) test data.}

\item{res.lasso}{If \code{TRUE} a lasso penalty is applied.}

\item{loss}{Loss function. The options are \code{"hinge"}, \code{"ramp"},
\code{"logit"}, \code{"logit.lasso"}, \code{"l2"}, \code{"l2.lasso"}.}

\item{kernel}{Type of kernel used by the support vector machine. The
options are \code{"linear"}, \code{"rbf"}.}

\item{augment}{If \code{TRUE} the outcomes are augmented.}

\item{c}{Regularization parameter.}

\item{sigma}{Tuning parameter.}

\item{s}{Slope parameter.}

\item{m}{Number of folds for cross-validation of the parameters.}
}
\value{
list of (default) control arguments.
}
\description{
\code{control_owl()} sets the default control arguments
for backwards outcome weighted learning, \code{type = "owl"}.
The arguments are passed directly to \code{\link[DTRlearn2:owl]{DTRlearn2::owl()}} if not
specified otherwise.
}
