% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqData_wrappers.R
\name{diffexp_seq}
\alias{diffexp_seq}
\title{Differential Expression for seqData}
\usage{
diffexp_seq(
  omicsData,
  method = "edgeR",
  p_adjust = "BH",
  comparisons = NULL,
  p_cutoff = 0.05,
  ...
)
}
\arguments{
\item{omicsData}{object of type 'seqData' created by
\code{\link{as.seqData}}}

\item{method}{character string of length one specifying which wrapper to
use. Can be 'edgeR', 'DESeq2', or 'voom'}

\item{p_adjust}{character string for p-value correction method, refer to
?p.adjust() for valid options. Defaults to "BH" (Benjamini & Hochberg).}

\item{comparisons}{data frame with columns for "Control" and "Test"
containing the different comparisons of interest. Comparisons will be made
between the Test and the corresponding Control  If left NULL, then all
pairwise comparisons are executed.}

\item{p_cutoff}{numeric value between 0 and 1 for setting p-value
significance threshold}

\item{...}{additional arguments passed to methods functions. Note, formatting
option changes will interfere with wrapping functionality.}
}
\value{
object of class statRes
}
\description{
Performs statistical analysis for differential expression of seqData objects,
using methods from one of: edgeR, DESeq2, or limma-voom
}
\details{
Runs default differential expression workflows.

Flags (signatures) -	Indicator of statistical significance.
Zeroes indicate no significance, while +/- 1 indicates direction of
significance.

Method "edgeR" - Runs default edgeR workflow with empirical Bayes
quasi-likelihood F-tests. Additional arguments can be passed for use in the
function. Refer to calcNormFactors() and glmQLFit() in edgeR package.
Requires the 'edgeR' and 'limma' packages to run.

Method "DESeq2" - Runs default DESeq workflow. Defaults to Wald test, no
independent filtering, and running in parallel. Additional arguments can be
passed for use in the function. Refer to DESeq() and results() in DESeq2
package. Requires 'survival' package to run.

Method "voom" - Runs default limma-voom workflow using empirical Bayes
moderated t-statistics. Additional arguments can be passed for use in the
function. Refer to calcNormFactors() in edgeR package.
Requires the 'edgeR' and 'limma' packages to run.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(pmartRdata)
myseqData <- group_designation(omicsData = rnaseq_object, main_effects = "Virus")
edger_results <- diffexp_seq(omicsData = myseqData, method = "edgeR")
deseq_results <- diffexp_seq(omicsData = myseqData, method = "DESeq2")
voom_results <- diffexp_seq(omicsData = myseqData, method = "voom")
}
\dontshow{\}) # examplesIf}
}
\references{
Robinson MD, McCarthy DJ, Smyth GK (2010). “edgeR: a Bioconductor package
 for differential expression analysis of digital gene expression data.”
 Bioinformatics, 26(1), 139-140. doi: 10.1093/bioinformatics/btp616.

 Love, M.I., Huber, W., Anders, S. Moderated estimation of fold change and
 dispersion for RNA-seq data with DESeq2 Genome Biology 15(12):550 (2014)

 Ritchie, M.E., Phipson, B., Wu, D., Hu, Y., Law, C.W., Shi, W., and Smyth,
 G.K. (2015). limma powers differential expression analyses for
 RNA-sequencing and microarray studies. Nucleic Acids Research 43(7), e47.
}
