% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.plsRmodel.R
\name{coef.plsRmodel}
\alias{coef.plsRmodel}
\title{coef method for plsR models}
\usage{
\method{coef}{plsRmodel}(object, type = c("scaled", "original"), ...)
}
\arguments{
\item{object}{an object of the class \code{"plsRmodel"}}

\item{type}{if \code{scaled}, the coefficients of the predictors are given
for the scaled predictors, if \code{original} the coefficients are to be
used with the predictors on their original scale.}

\item{\dots}{not used}
}
\value{
An object of class \code{coef.plsRmodel}.\cr
\item{CoeffC}{Coefficients of the components.}
\item{Std.Coeffs}{Coefficients of the scaled predictors.}
\item{Coeffs}{Coefficients of the untransformed predictors (on their
original scale).}
}
\description{
This function provides a coef method for the class \code{"plsRmodel"}
}
\examples{

data(Cornell)
XCornell<-Cornell[,1:7]
yCornell<-Cornell[,8]
modpls <- plsRglm(yCornell,XCornell,3,modele="pls")
class(modpls)
coef(modpls)
coef(modpls,type="scaled")
rm(list=c("XCornell","yCornell","modpls"))

}
\seealso{
\code{\link{coef}}
}
\author{
Frédéric Bertrand\cr
\email{frederic.bertrand@utt.fr}\cr
\url{https://fbertran.github.io/homepage/}
}
\keyword{coef}
\keyword{methods}
