% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_free.R
\name{scale_free}
\alias{scale_free}
\title{Scale values into a Certain Location}
\usage{
scale_free(
  x,
  left = 0,
  right = 1,
  reverse = FALSE,
  xmin = NULL,
  xmax = NULL,
  na.rm = FALSE
)
}
\arguments{
\item{x}{a numeric vector or a numeric matrix, 
data frame, tibble object.}

\item{left}{the smallest value of the the interval. 
If \code{x} has n columns, then \code{left}
 is expected to 
be of length n. However, if it is shorter, it will be 
repeated to reach that length.}

\item{right}{the largest value of the the interval. 
If \code{x} has n columns, then \code{right}
 is expected to 
be of length n. However, if it is shorter, it will be 
repeated to reach that length.}

\item{reverse}{whether to assign values in a 
reverse way. Default is FALSE. 
If \code{x} has n columns, then \code{reverse}
 is expected to 
be of length n. However, if it is shorter, it will be 
repeated to reach that length.}

\item{xmin}{the min value. Default is NULL, 
which means use the min value of \code{x}. However, 
sometimes the min value of \code{x} may not be the 
true min value. Suppose the two scores of a 
100-point test are 59, 87, then the true min score is 0 
and the true max score is 100. Thus you must 
add \code{xmin = 0, xmax = 100}. 
If \code{reverse = TRUE} (that is, 0 is better than 100), 
also add \code{xmin = 0, xmax = 100}.}

\item{xmax}{the same meaning as \code{xmin}, 
but for max value.}

\item{na.rm}{used by \code{min} and \code{max}. 
Default is FALSE.}
}
\description{
A simple function to put numeric values into 
a certain interval. Suppose you have 
20, 60, 80, 100, and you want them to be in the 
interval of [0, 1], so you can get 0, 0.5, 0.75, 1.
}
\examples{
y=scale_free(c(-1, 0, 2))
y=scale_free(c(-1, 0, 2), rev=TRUE)
#
# x is a data frame.
x=data.frame(
	c(-1, 0, 0, 0, 2), c(-1, 0, 0, 0, 2), 
	c(-2, 0, 2, 4, 6), c(-2, 0, 2, 4, 6)
)
y=scale_free(x, 
	left=0, right=10, 
	reverse=c(FALSE, TRUE, FALSE, TRUE)
)
y=scale_free(x, 
	left=c(0, 0, 100, 100), right=c(10, 100, 200, 200), 
	reverse=c(FALSE, TRUE, FALSE, TRUE)
)
}
