% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_indexes.R
\name{pliman_indexes_ican_compute}
\alias{pliman_indexes_ican_compute}
\title{List Computable Indexes Based on Available Bands}
\usage{
pliman_indexes_ican_compute(available)
}
\arguments{
\item{available}{A character vector of available bands (e.g., \code{c("R", "G")}).}
}
\value{
A data frame of indexes that can be computed with the available bands.
}
\description{
This function reads index equations from a CSV file included in the \code{pliman}
package, determines which bands are used in each index equation, and checks
which indexes can be computed based on the provided available bands.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
available_bands <- c("R", "G")
computable_indexes <- pliman_indexes_ican_compute(available_bands)
print(computable_indexes)
}
}
