% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_draw}
\alias{mosaic_draw}
\title{Drawing Lines or Polygons with Raster Information}
\usage{
mosaic_draw(
  mosaic,
  r = 3,
  g = 2,
  b = 1,
  re = 4,
  nir = 5,
  index = "NGRDI",
  show = "rgb",
  segment = FALSE,
  viewer = c("mapview", "base"),
  threshold = "Otsu",
  invert = FALSE,
  summarize_fun = NULL,
  buffer = 2,
  color_regions = rev(grDevices::terrain.colors(50)),
  alpha = 1,
  max_pixels = 1e+06,
  downsample = NULL,
  quantiles = c(0, 1),
  plot = TRUE,
  plot_layout = c(1, 2, 3, 3)
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{r, g, b, re, nir}{The red, green, blue, red-edge, and  near-infrared bands
of the image, respectively. By default, the function assumes a BGR as input
(b = 1, g = 2, r = 3). If a multispectral image is provided up to seven
bands can be used to compute built-in indexes. There are no limitation of
band numbers if the index is computed using the band name.}

\item{index}{The index to use for the index view. Defaults to "B".}

\item{show}{The display option for the map view. Options are "rgb" for RGB
view and "index" for index view.}

\item{segment}{Should the raster object be segmented? If set to \code{TRUE},
pixels within each polygon/rectangle will be segmented based on the
\code{threshold} argument.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{threshold}{By default (threshold = "Otsu"), a threshold value based on
Otsu's method is used to reduce the grayscale image to a binary image. If a
numeric value is informed, this value will be used as a threshold.}

\item{invert}{Inverts the mask if desired. Defaults to \code{FALSE}.}

\item{summarize_fun}{An optional function or character vector. When
\code{summarize_fun = "mean"}, the mean values of \code{index} are calculated within
each object. For more details on available functions, refer to
\code{\link[exactextractr:exact_extract]{exactextractr::exact_extract()}}.}

\item{buffer}{Adds a buffer around the geometries of the SpatVector created.
Note that the distance unit of \code{buffer} will vary according to the CRS of
\code{mosaic}.}

\item{color_regions}{The color palette for displaying index values. Defaults
to \code{rev(grDevices::terrain.colors(50))}.}

\item{alpha}{opacity of the fill color of the raster layer(s).}

\item{max_pixels}{Maximum number of pixels to render in the map or plot
(default: 500000).}

\item{downsample}{Downsampling factor to reduce the number of pixels
(default: NULL). In this case, if the number of pixels in the image (width
x height) is greater than \code{max_pixels} a downsampling factor will be
automatically chosen so that the number of plotted pixels approximates the
\code{max_pixels}.}

\item{quantiles}{the upper and lower quantiles used for color stretching.}

\item{plot}{Plots the draw line/rectangle? Defaults to \code{TRUE}.}

\item{plot_layout}{The de plot layout. Defaults to \code{plot_layout = c(1, 2, 3, 3)}. Ie., the first row has two plots, and the second row has one plot.}
}
\value{
An invisible list containing the mosaic, draw_data, distance,
distance_profile, geometry, and map.
}
\description{
Drawing Lines or Polygons with Raster Information
}
\details{
The \code{mosaic_draw} function enables you to create mosaic drawings from
remote sensing data and compute vegetation indices.
\itemize{
\item If a line is drawn using the "Draw Polyline" tool, the profile of \code{index} is
displayed on the y-axis along the line's distance, represented in meter
units. It is important to ensure that the Coordinate Reference System (CRS)
of \code{mosaic} has latitude/longitude units for accurate distance
representation.
\item If a rectangle or polygon is drawn using the "Draw Rectangle" or "Draw Polygon"
tools, the \code{index} values are calculated for each object. By default, the
raw data is returned. You can set the \code{summarize_fun} to compute a summary
statistic for each object.
}
}
\examples{

if (interactive() && requireNamespace("EBImage")) {
library(pliman)
# Load a raster showing the elevation of Luxembourg
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))

# draw a polyline to see the elevation profile along the line
mosaic_draw(mosaic, buffer = 1500)
}
}
